/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.CompileClassPathImpl;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.openide.util.Utilities;

class TestCompileClassPathImpl
extends AbstractProjectClassPathImpl
implements FlaggedClassPathImplementation {
    private volatile boolean incomplete;
    private final boolean addTestOutDir;
    private final boolean testScoped;

    public TestCompileClassPathImpl(NbMavenProjectImpl proj, boolean addTestOutDir) {
        this(proj, addTestOutDir, false);
    }

    public TestCompileClassPathImpl(NbMavenProjectImpl proj, boolean addTestOutDir, boolean testScoped) {
        super(proj);
        this.addTestOutDir = addTestOutDir;
        this.testScoped = testScoped;
    }

    @Override
    URI[] createPath() {
        ArrayList<URI> lst = new ArrayList<URI>();
        MavenProject mavenProject = this.getMavenProject().getOriginalMavenProject();
        List arts = mavenProject.getTestArtifacts();
        boolean broken = false;
        for (Artifact art : arts) {
            File f = TestCompileClassPathImpl.getFile(art);
            if (f != null) {
                lst.add(Utilities.toURI((File)f));
                broken |= !f.exists();
                continue;
            }
            broken = true;
        }
        if (this.testScoped) {
            ArrayList<URI> cmplst = new ArrayList<URI>();
            broken |= CompileClassPathImpl.getCompileArtifacts(mavenProject, cmplst);
            lst.removeAll(cmplst);
        }
        if (this.incomplete != broken) {
            this.incomplete = broken;
            this.firePropertyChange("flags", null, null);
        }
        if (this.addTestOutDir) {
            lst.add(0, Utilities.toURI((File)this.getMavenProject().getProjectWatcher().getOutputDirectory(true)));
        }
        lst.add(0, Utilities.toURI((File)this.getMavenProject().getProjectWatcher().getOutputDirectory(false)));
        URI[] uris = new URI[lst.size()];
        uris = lst.toArray(uris);
        return uris;
    }

    public Set<ClassPath.Flag> getFlags() {
        return this.incomplete ? EnumSet.of(ClassPath.Flag.INCOMPLETE) : Collections.emptySet();
    }
}

