/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.controlflow;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.model.InputBlockEdge;
import org.graalvm.visualizer.controlflow.BlockWidget;
import org.graalvm.visualizer.controlflow.ControlFlowScene;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;

public class BlockConnectionWidget
extends ConnectionWidget
implements Link {
    private static final Stroke NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke BOLD_STROKE = new BasicStroke(2.5f);
    private static final Stroke DASHED_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private static final Stroke BOLD_DASHED_STROKE = new BasicStroke(2.5f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private final BlockWidget from;
    private final BlockWidget to;
    private final Port inputSlot;
    private final Port outputSlot;
    private List<Point> points;
    private final InputBlockEdge edge;
    private boolean isDashed;
    private boolean isBold;

    public BlockConnectionWidget(ControlFlowScene scene, InputBlockEdge edge) {
        super((Scene)scene);
        this.edge = edge;
        this.from = (BlockWidget)scene.findWidget(edge.getFrom());
        this.to = (BlockWidget)scene.findWidget(edge.getTo());
        this.inputSlot = this.to.getInputSlot();
        this.outputSlot = this.from.getOutputSlot();
        this.points = new ArrayList<Point>();
    }

    public InputBlockEdge getEdge() {
        return this.edge;
    }

    public Port getTo() {
        return this.inputSlot;
    }

    public Port getFrom() {
        return this.outputSlot;
    }

    public void setBold(boolean bold) {
        this.isBold = bold;
        this.updateStroke();
    }

    public void setDashed(boolean dashed) {
        this.isDashed = dashed;
        this.updateStroke();
    }

    private void updateStroke() {
        Stroke stroke = NORMAL_STROKE;
        if (this.isBold) {
            stroke = this.isDashed ? BOLD_DASHED_STROKE : BOLD_STROKE;
        } else if (this.isDashed) {
            stroke = DASHED_STROKE;
        }
        this.setStroke(stroke);
    }

    public void setControlPoints(List<Point> p) {
        this.points = p;
    }

    public List<Point> getControlPoints() {
        return this.points;
    }

    public String toString() {
        return "Connection[ " + this.from.toString() + " - " + this.to.toString() + "]";
    }

    public boolean isVIP() {
        return this.isBold;
    }
}

