/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.search.Bundle;
import org.graalvm.visualizer.search.Criteria;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.NodesList;
import org.graalvm.visualizer.search.NodesProvider;
import org.graalvm.visualizer.search.SearchController;
import org.graalvm.visualizer.search.SearchEvent;
import org.graalvm.visualizer.search.SearchListener;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.SearchTask;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class GraphSearchEngine
implements SearchController {
    private static final RequestProcessor SEARCH_RP = new RequestProcessor("Graph Searches", 10);
    private final GraphContainer graphList;
    private final InputGraph initialGraph;
    private final NodesProvider provider;
    private BlockingQueue<InputGraph> toSearch = new LinkedBlockingQueue<InputGraph>();
    private Set<InputGraph> searched = new HashSet<InputGraph>();
    private SearchResultsModel model;
    private Criteria searchCriteria;
    private List<SearchListener> listeners = new ArrayList<SearchListener>();
    private SearchTask pending;
    private SearchRunnable pendingRunnable;

    public GraphSearchEngine(GraphContainer graphList, InputGraph initialGraph, NodesProvider provider) {
        this.graphList = graphList;
        this.initialGraph = initialGraph;
        this.provider = provider;
        this.model = new SearchResultsModel();
        this.pending = SearchTask.finished(this.model);
        this.searchCriteria = new Criteria().setMatcher(Properties.PropertyMatcher.ALL);
    }

    @Override
    public void addSearchListener(SearchListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeSearchListener(SearchListener l) {
        this.listeners.remove(l);
    }

    @Override
    public SearchResultsModel getResults() {
        return this.model;
    }

    @Override
    public GraphContainer getGraphContainer() {
        return this.graphList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InputGraph> getSearchedGraphs() {
        HashSet<InputGraph> result = new HashSet<InputGraph>();
        GraphSearchEngine graphSearchEngine = this;
        synchronized (graphSearchEngine) {
            result.addAll(this.searched);
            this.toSearch.drainTo(result);
        }
        return result;
    }

    @Override
    public boolean canSearch(boolean previous) {
        ArrayList gr = new ArrayList(this.graphList.getGraphs());
        if (gr.size() < 2) {
            return false;
        }
        InputGraph mark = (InputGraph)gr.get(previous ? 0 : gr.size() - 1);
        if (this.toSearch.contains(mark)) {
            return false;
        }
        return !this.searched.contains(mark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchTask extendSearch(boolean previous, boolean stopFirst) {
        SearchTask t = null;
        if (!this.canSearch(previous)) {
            return null;
        }
        GraphSearchEngine graphSearchEngine = this;
        synchronized (graphSearchEngine) {
            ArrayList<InputGraph> known = new ArrayList<InputGraph>(this.toSearch);
            known.addAll(this.searched);
            List contents = this.graphList.getGraphs();
            if (known.isEmpty()) {
                known.add(this.initialGraph);
            }
            int randomIndex = contents.indexOf(known.get(0));
            ArrayList extend = new ArrayList(previous ? contents.subList(0, randomIndex) : contents.subList(randomIndex + 1, contents.size()));
            extend.removeAll(known);
            this.toSearch.addAll(extend);
            if (this.pending != null && !this.pending.isFinished()) {
                t = this.pending;
                this.pendingRunnable.stopAfterFirstFound &= stopFirst;
            }
        }
        if (t == null) {
            t = this.doNewSearch(this.model, this.searchCriteria, stopFirst);
        }
        return t;
    }

    @Override
    public SearchTask pendingSearch() {
        return this.pending;
    }

    @Override
    public Criteria getCriteria() {
        return this.searchCriteria;
    }

    @Override
    public SearchTask newSearch(Criteria crit, boolean replace) {
        SearchResultsModel m = this.model;
        if (m != null && !replace) {
            m.clear();
        } else {
            m = new SearchResultsModel();
        }
        return this.doNewSearch(m, crit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchTask doNewSearch(SearchResultsModel m, Criteria crit, boolean stop) {
        SearchTask st;
        SearchRunnable run = new SearchRunnable(this.toSearch, m, crit.getMatcher());
        run.stopAfterFirstFound = stop;
        GraphSearchEngine graphSearchEngine = this;
        synchronized (graphSearchEngine) {
            this.toSearch.add(this.initialGraph);
            this.searchCriteria = crit;
            if (this.model != m) {
                this.searched.clear();
            }
            this.model = m;
            if (this.pending != null) {
                this.pending.cancel();
            }
            RequestProcessor.Task t = SEARCH_RP.post((Runnable)run);
            st = new SearchTask(t, run, this.model);
            run.attachTask(st);
            this.pendingRunnable = run;
            this.pending = st;
        }
        this.fireListeners(SearchListener::searchStarted, () -> new SearchEvent((SearchController)this, st, null, this.model));
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireListeners(BiConsumer<SearchListener, SearchEvent> method, Supplier<SearchEvent> p) {
        ArrayList<SearchListener> ll;
        GraphSearchEngine graphSearchEngine = this;
        synchronized (graphSearchEngine) {
            if (this.listeners.isEmpty()) {
                return false;
            }
            ll = new ArrayList<SearchListener>(this.listeners);
        }
        SearchEvent e = p.get();
        ll.forEach(l -> method.accept((SearchListener)l, e));
        return e.isTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphFinished(InputGraph g) {
        GraphSearchEngine graphSearchEngine = this;
        synchronized (graphSearchEngine) {
            this.searched.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFinished(SearchRunnable r) {
        GraphSearchEngine graphSearchEngine = this;
        synchronized (graphSearchEngine) {
            this.toSearch.clear();
            if (this.pendingRunnable == r) {
                this.pendingRunnable = null;
            }
        }
    }

    @Override
    public String getTitle() {
        return Bundle.TITLE_SearchInGraph(this.initialGraph.getName(), this.getCriteria().toDisplayString(false));
    }

    @Override
    public NodesProvider getNodesProvider() {
        return this.provider;
    }

    @Override
    public InputGraph getInitialGraph() {
        return this.initialGraph;
    }

    public Collection<InputGraph> getToSearch() {
        ArrayList<InputGraph> c = new ArrayList<InputGraph>();
        this.toSearch.drainTo(c);
        return c;
    }

    public synchronized Set<InputGraph> getSearched() {
        return new HashSet<InputGraph>(this.searched);
    }

    class SearchRunnable
    implements Runnable,
    Cancellable {
        private final BlockingQueue<InputGraph> toSearch;
        private final SearchResultsModel target;
        private final Properties.PropertyMatcher selector;
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private volatile boolean stopAfterFirstFound = true;
        private int found;
        private SearchTask myTask;
        private NodesList nl;
        private List<InputNode> selected;
        private long lastPublished;
        private GraphItem ownerItem;

        public SearchRunnable(BlockingQueue<InputGraph> toSearch, SearchResultsModel target, Properties.PropertyMatcher selector) {
            this.toSearch = toSearch;
            this.target = target;
            this.selector = selector;
        }

        public SearchRunnable setStopAfterFirstFound(boolean stopAfterFirstFound) {
            this.stopAfterFirstFound = stopAfterFirstFound;
            return this;
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }

        Collection<InputGraph> getPendingGraphs() {
            HashSet<InputGraph> pending = new HashSet<InputGraph>();
            this.toSearch.drainTo(pending);
            return pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            GraphSearchEngine graphSearchEngine = GraphSearchEngine.this;
            synchronized (graphSearchEngine) {
                this.cancelled.set(true);
                return !this.myTask.isFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attachTask(SearchTask t) {
            GraphSearchEngine graphSearchEngine = GraphSearchEngine.this;
            synchronized (graphSearchEngine) {
                this.myTask = t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputGraph g;
            GraphSearchEngine graphSearchEngine = GraphSearchEngine.this;
            synchronized (graphSearchEngine) {
                g = (InputGraph)this.toSearch.poll();
            }
            try {
                while (g != null && !this.cancelled.get()) {
                    Object next;
                    GraphSearchEngine graphSearchEngine2 = GraphSearchEngine.this;
                    synchronized (graphSearchEngine2) {
                        if (GraphSearchEngine.this.pending != this.myTask) {
                            break;
                        }
                    }
                    try {
                        this.ownerItem = new GraphItem(g.getGraphType(), (FolderElement)g);
                        this.found = 0;
                        this.selected = new ArrayList<InputNode>();
                        this.lastPublished = System.currentTimeMillis();
                        this.processGraph(g);
                        graphSearchEngine2 = GraphSearchEngine.this;
                    }
                    catch (Throwable throwable) {
                        GraphSearchEngine graphSearchEngine3 = GraphSearchEngine.this;
                        synchronized (graphSearchEngine3) {
                            next = !this.selected.isEmpty() && this.stopAfterFirstFound ? null : (InputGraph)this.toSearch.poll();
                            if (next == null) {
                                GraphSearchEngine.this.notifyFinished(this);
                            }
                        }
                        GraphSearchEngine.this.searched.add(g);
                        this.publishSelected(g, true, next != null);
                        this.nl = null;
                        throw throwable;
                    }
                    synchronized (graphSearchEngine2) {
                        next = !this.selected.isEmpty() && this.stopAfterFirstFound ? null : (InputGraph)this.toSearch.poll();
                        if (next == null) {
                            GraphSearchEngine.this.notifyFinished(this);
                        }
                    }
                    GraphSearchEngine.this.searched.add(g);
                    this.publishSelected(g, true, next != null);
                    this.nl = null;
                    if (g == next) {
                        break;
                    }
                    g = next;
                }
            }
            finally {
                GraphSearchEngine.this.fireListeners(SearchListener::searchFinished, () -> new SearchEvent((SearchController)GraphSearchEngine.this, this.myTask, this.target, true));
            }
        }

        private void publishSelected(InputGraph g, boolean finished, boolean allFinished) {
            ArrayList<NodeResultItem> items = new ArrayList<NodeResultItem>();
            int traversed = this.nl != null ? this.nl.visitedCount() : -1;
            for (InputNode in : this.selected) {
                items.add(new NodeResultItem(this.ownerItem, in));
            }
            this.selected.clear();
            this.target.addAll(items);
            if (finished) {
                GraphSearchEngine.this.notifyGraphFinished(g);
                GraphSearchEngine.this.fireListeners(SearchListener::finished, () -> new SearchEvent(GraphSearchEngine.this, this.myTask, (FolderElement)g, this.target, traversed, this.found, true, allFinished));
            } else {
                boolean term = GraphSearchEngine.this.fireListeners(SearchListener::searchProgress, () -> new SearchEvent(GraphSearchEngine.this, this.myTask, (FolderElement)g, this.target, traversed, this.found, false, false));
                if (term) {
                    this.cancelled.set(true);
                }
            }
        }

        private void processGraph(InputGraph g) {
            if (GraphSearchEngine.this.fireListeners(SearchListener::loading, () -> new SearchEvent((SearchController)GraphSearchEngine.this, this.myTask, (FolderElement)g, this.target))) {
                this.cancelled.set(true);
                return;
            }
            Collection nodes = g.getNodes();
            if (GraphSearchEngine.this.fireListeners(SearchListener::started, () -> new SearchEvent((SearchController)GraphSearchEngine.this, this.myTask, (FolderElement)g, this.target))) {
                this.cancelled.set(true);
                return;
            }
            this.nl = GraphSearchEngine.this.provider.nodes(g);
            int cnt = 0;
            while (this.nl.hasNext() && !this.cancelled.get()) {
                InputNode n = (InputNode)this.nl.next();
                Properties np = n.getProperties();
                if (this.selector.matchProperties(np) != null) {
                    this.selected.add(n);
                    ++this.found;
                }
                if (++cnt % 100 != 0 || System.currentTimeMillis() - this.lastPublished <= 500L) continue;
                this.publishSelected(g, false, false);
            }
        }
    }
}

