/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.data.services.NodeContext;
import org.graalvm.visualizer.search.ContextNode;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.Bundle;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.graalvm.visualizer.util.swing.ActionUtils;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.netbeans.api.actions.Openable;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class ItemNode
extends AbstractNode {
    private final SearchResultsModel results;
    private final Lookup context;
    private final NodeResultItem result;
    private final InstanceContent content;
    private InputNode node;
    private static final RequestProcessor OPEN_RP = new RequestProcessor("open search item", 1);

    public static Node createNode(SearchResultsModel model, NodeResultItem result, Lookup lkp) {
        return new ItemNode(model, result, lkp, new InstanceContent());
    }

    public ItemNode(SearchResultsModel model, NodeResultItem result) {
        this(model, result, Lookup.EMPTY, new InstanceContent());
    }

    private static Lookup combine(Lookup lkp, InstanceContent content) {
        AbstractLookup ll = new AbstractLookup((AbstractLookup.Content)content);
        if (lkp == Lookup.EMPTY) {
            return ll;
        }
        return new ProxyLookup(new Lookup[]{lkp, ll});
    }

    public ItemNode(SearchResultsModel model, final NodeResultItem result, Lookup lkp, InstanceContent content) {
        super(Children.LEAF, ItemNode.combine(lkp, content));
        this.results = model;
        this.content = content;
        this.result = result;
        this.context = lkp;
        this.setIconBaseWithExtension("org/graalvm/visualizer/search/resources/singleitem.png");
        Sheet sheet = new Sheet();
        PropertiesSheet.initializeSheet((Properties)result.getItemProperties(), (Sheet)sheet);
        this.setSheet(sheet);
        Sheet.Set propSet = new Sheet.Set();
        propSet.setName("structure");
        propSet.setDisplayName(Bundle.PROPSET_Structure());
        sheet.put(propSet);
        propSet.put((Node.Property)new PropertySupport.ReadOnly<String>("graph", String.class, Bundle.PROPNAME_Graph(), Bundle.PROPDESC_Graph()){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return result.getOwner().getDisplayName();
            }
        });
        InputGraph parent = (InputGraph)result.getOwner().getData();
        if (parent != null) {
            content.add((Object)parent);
        }
        content.add((Object)result);
        content.add((Object)new OpenAndSelect());
        this.updateNodeCookie();
        this.setName(Bundle.FMT_NodeName(result.getNodeId(), result.getItemProperties().get("name")));
    }

    private void updateNodeCookie() {
        InputNode n;
        GraphItem ow = this.result.getOwner();
        InputGraph in = (InputGraph)ow.getData();
        if (in != null && (n = in.getNode(this.result.getNodeId())) != null) {
            this.node = new ContextNode(new NodeContext(n, in, (GraphContainer)in.getGroup()));
            this.content.add((Object)this.node);
        }
    }

    public Action getPreferredAction() {
        return ActionUtils.findAction((String)"System", (String)"org.openide.actions.OpenAction", (Lookup)Lookup.EMPTY);
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> aa = new ArrayList<Action>(Arrays.asList(super.getActions(context)));
        aa.addAll(Arrays.asList(Actions.forID((String)"Diagram", (String)"org.graalvm.visualizer.search.gotonode"), Actions.forID((String)"Diagram", (String)"org.graalvm.visualizer.search.extractnodes")));
        return aa.toArray(new Action[aa.size()]);
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        this.results.remove(this.result);
    }

    class OpenAndSelect
    extends AbstractAction
    implements Openable {
        public void open() {
            GraphItem owner = ItemNode.this.result.getOwner();
            owner.resolve(null).thenAcceptAsync(this::openTargetGraph, (Executor)OPEN_RP);
        }

        private void openTargetGraph(FolderElement fe) {
            if (!(fe instanceof InputGraph)) {
                return;
            }
            InputGraph ig = (InputGraph)fe;
            int id = ItemNode.this.result.getNodeId();
            InputNode node = ig.getNode(id);
            if (node == null) {
                return;
            }
            GraphViewer vwr = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
            vwr.view((s, g) -> this.navigateInGraph((InputGraphProvider)g, node), ig, false, true, new Object[0]);
        }

        private void navigateInGraph(InputGraphProvider g, InputNode node) {
            DiagramViewer dgw = (DiagramViewer)g;
            Set<InputNode> col = Collections.singleton(node);
            Collection figs = dgw.figuresForNodes(col);
            if (figs.isEmpty()) {
                StatusDisplayer.getDefault().setStatusText(Bundle.WARNING_NodeNotVisible(node.getId()), 3);
            }
            g.setSelectedNodes(Collections.singleton(node));
            TopComponent tc = (TopComponent)dgw.getLookup().lookup(TopComponent.class);
            if (tc != null) {
                tc.requestFocus();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.open();
        }
    }
}

