/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.search.ui.Bundle;
import org.graalvm.visualizer.search.ui.SearchResultsEntry;
import org.graalvm.visualizer.util.StringUtils;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="node-search-results", persistenceType=0, iconBase="org/netbeans/modules/search/res/find.gif")
public final class ResultView
extends TopComponent {
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final String CARD_NAME_EMPTY = "empty";
    private static final String CARD_NAME_TABS = "tabs";
    private static final String CARD_NAME_SINGLE = "single";
    static final String ID = "node-search-results";
    private JPopupMenu pop;
    private PopupListener popL;
    private CloseListener closeL;
    private JPanel emptyPanel;
    private JPanel singlePanel;
    private JTabbedPane tabs;
    private PanelPropL propL = new PanelPropL();
    private WeakReference<JPanel> tabToReuse;
    private CurrentLookupProvider lookupProvider = new CurrentLookupProvider();
    private final CardLayout contentCards = new CardLayout();

    public static synchronized ResultView getInstance() {
        ResultView view = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (view == null) {
            view = new ResultView();
        }
        return view;
    }

    public ResultView() {
        this.setLayout(this.contentCards);
        this.setName("Search Results");
        this.setDisplayName(Bundle.TITLE_SearchResults());
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.popL = new PopupListener();
        this.closeL = new CloseListener();
        this.emptyPanel = new JPanel();
        this.singlePanel = new JPanel();
        this.singlePanel.setLayout(new BoxLayout(this.singlePanel, 3));
        this.emptyPanel.setOpaque(true);
        this.tabs = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ResultView.this.updateLookup();
            }
        });
        this.tabs.setMinimumSize(new Dimension(0, 0));
        this.tabs.addMouseListener((MouseListener)((Object)this.popL));
        this.tabs.addPropertyChangeListener(this.closeL);
        this.add(this.emptyPanel, CARD_NAME_EMPTY);
        this.add(this.tabs, CARD_NAME_TABS);
        this.add(this.singlePanel, CARD_NAME_SINGLE);
        if (isMacLaf) {
            this.emptyPanel.setBackground(macBackground);
            this.tabs.setBackground(macBackground);
            this.tabs.setOpaque(true);
            this.setBackground(macBackground);
            this.setOpaque(true);
        } else {
            this.emptyPanel.setBackground(UIManager.getColor("Tree.background"));
        }
        this.contentCards.show((Container)((Object)this), CARD_NAME_EMPTY);
        this.associateLookup(Lookups.proxy((Lookup.Provider)this.lookupProvider));
    }

    void closeResults() {
        this.close();
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        SearchResultsEntry entry = this.getCurrentResultEntry();
        if (entry != null) {
            entry.viewOpened();
        }
        this.setToolTipText(Bundle.TOOLTIP_SearchResults());
    }

    public void requestFocus() {
        JPanel panel = this.getCurrentResultViewPanel();
        if (panel != null) {
            panel.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        JPanel panel = this.getCurrentResultViewPanel();
        if (panel != null) {
            return panel.requestFocusInWindow();
        }
        return false;
    }

    private JPanel getCurrentResultViewPanel() {
        JComponent comp = null;
        if (this.singlePanel.getComponents().length == 1) {
            comp = (JComponent)this.singlePanel.getComponents()[0];
        } else if (this.tabs.getTabCount() > 0) {
            comp = (JComponent)this.tabs.getSelectedComponent();
        }
        return comp instanceof JPanel ? (JPanel)comp : null;
    }

    private SearchResultsEntry getCurrentResultEntry() {
        JComponent comp = null;
        if (this.singlePanel.getComponents().length == 1) {
            comp = (JComponent)this.singlePanel.getComponents()[0];
        } else if (this.tabs.getTabCount() > 0) {
            comp = (JComponent)this.tabs.getSelectedComponent();
        }
        if (comp == null) {
            return null;
        }
        return this.panel2SearchEntry(comp);
    }

    private void updateTabTitle(JPanel panel) {
        if (this.getComponentCount() != 0 && this.tabs.getTabCount() > 0) {
            int index = this.tabs.indexOfComponent(panel);
            this.tabs.setTitleAt(index, panel.getName());
            this.tabs.setToolTipTextAt(index, panel.getToolTipText());
        }
    }

    private SearchResultsEntry panel2SearchEntry(Component comp) {
        if (!(comp instanceof JComponent)) {
            return null;
        }
        Object o = ((JComponent)comp).getClientProperty("search.entry");
        if (o instanceof SearchResultsEntry) {
            return (SearchResultsEntry)o;
        }
        return null;
    }

    private void removePanel(Component panel) {
        panel.removePropertyChangeListener(this.propL);
        if (this.tabs.getTabCount() > 0) {
            this.closeEntry(this.panel2SearchEntry(panel));
            this.tabs.remove(panel);
        } else if (this.singlePanel.getComponents().length == 1) {
            Component comp = this.singlePanel.getComponents()[0];
            this.closeEntry(this.panel2SearchEntry(comp));
            this.singlePanel.remove(comp);
        } else {
            this.close();
        }
        if (this.tabs.getTabCount() == 0) {
            this.contentCards.show((Container)((Object)this), CARD_NAME_EMPTY);
        } else if (this.tabs.getTabCount() == 1) {
            Component c = this.tabs.getComponentAt(0);
            this.singlePanel.add(c);
            this.contentCards.show((Container)((Object)this), CARD_NAME_SINGLE);
        }
        this.updateLookup();
        this.validate();
        this.updateTooltip();
    }

    private void closeEntry(SearchResultsEntry en) {
        if (en != null) {
            en.cancelSearch();
            en.viewClosed();
        }
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        this.closeAll(false);
    }

    void showAllDetailsFinished() {
        assert (EventQueue.isDispatchThread());
    }

    private void closeAll(boolean butCurrent) {
        Component comp;
        if (this.tabs.getTabCount() > 0) {
            Component current = this.tabs.getSelectedComponent();
            Component[] c = this.tabs.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (butCurrent && c[i] == current || this.panel2SearchEntry(c[i]) == null) continue;
                this.removePanel(c[i]);
            }
        } else if (this.singlePanel.getComponents().length > 0 && this.panel2SearchEntry(comp = this.singlePanel.getComponents()[0]) != null) {
            this.removePanel(comp);
        }
    }

    JPanel addTab(SearchResultsEntry entry) {
        int tabIndex = this.tryReuse();
        JPanel panel = entry.getResultsPanel();
        if (panel == null) {
            return null;
        }
        panel.putClientProperty("search.entry", entry);
        if (this.singlePanel.getComponents().length == 0 && this.tabs.getTabCount() == 0) {
            this.singlePanel.add(panel);
            this.contentCards.show((Container)((Object)this), CARD_NAME_SINGLE);
            this.updateLookup();
        } else if (this.singlePanel.getComponents().length == 1) {
            JPanel comp = (JPanel)this.singlePanel.getComponents()[0];
            this.tabs.insertTab(comp.getName(), null, comp, comp.getToolTipText(), 0);
            this.tabs.setToolTipTextAt(0, comp.getToolTipText());
            int tabToInsert = tabIndex > -1 ? tabIndex : 1;
            this.tabs.insertTab(comp.getName(), null, panel, panel.getToolTipText(), tabToInsert);
            this.tabs.setToolTipTextAt(tabToInsert, panel.getToolTipText());
            this.tabs.setSelectedIndex(tabIndex > -1 ? tabIndex : 1);
            this.contentCards.show((Container)((Object)this), CARD_NAME_TABS);
            comp.addPropertyChangeListener(this.propL);
            panel.addPropertyChangeListener(this.propL);
        } else {
            this.tabs.insertTab(panel.getName(), null, panel, panel.getToolTipText(), tabIndex > -1 ? tabIndex : this.tabs.getTabCount());
            this.tabs.setToolTipTextAt(tabIndex > -1 ? tabIndex : this.tabs.getTabCount() - 1, panel.getToolTipText());
            this.tabs.setSelectedComponent(panel);
            this.tabs.validate();
            panel.addPropertyChangeListener(this.propL);
        }
        entry.viewOpened();
        this.validate();
        this.requestActive();
        this.updateTooltip();
        return panel;
    }

    private int tryReuse() {
        int index;
        JPanel toReuse = this.getTabToReuse();
        if (toReuse == null) {
            return -1;
        }
        if (this.singlePanel.getComponents().length == 1 && this.singlePanel.getComponent(0) == toReuse) {
            this.removePanel(toReuse);
            this.clearReusableTab();
            return 0;
        }
        if (this.tabs.getTabCount() > 0 && (index = this.tabs.indexOfComponent(toReuse)) >= 0) {
            this.removePanel(toReuse);
            this.clearReusableTab();
            return index;
        }
        return this.tabs.getTabCount();
    }

    public boolean isFocused() {
        JPanel rvp = this.getCurrentResultViewPanel();
        if (rvp != null) {
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            return owner != null && SwingUtilities.isDescendingFrom(owner, rvp);
        }
        return false;
    }

    private synchronized void setTabToReuse(JPanel resultViewPanel) {
        this.tabToReuse = resultViewPanel == null ? null : new WeakReference<JPanel>(resultViewPanel);
    }

    private synchronized JPanel getTabToReuse() {
        return this.tabToReuse == null || this.tabToReuse.get() == null ? null : (JPanel)this.tabToReuse.get();
    }

    public synchronized void markCurrentTabAsReusable() {
        this.setTabToReuse(this.getCurrentResultViewPanel());
    }

    public synchronized void clearReusableTab() {
        this.setTabToReuse(null);
    }

    private void updateLookup() {
        SearchResultsEntry en = this.getCurrentResultEntry();
        this.lookupProvider.setLookup(en == null ? Lookup.EMPTY : en.getLookup());
        this.getLookup().lookup(Object.class);
    }

    private void updateTooltip() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>");
        sb.append(Bundle.TOOLTIP_SearchResults());
        sb.append("</b>");
        if (this.singlePanel.getComponents().length == 1) {
            this.appendTabToToolTip(this.singlePanel.getComponent(0), sb);
        } else if (this.tabs.getComponents().length > 0) {
            Component[] comps = this.tabs.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.appendTabToToolTip(comps[i], sb);
            }
        }
        sb.append("</html>");
        this.setToolTipText(sb.toString());
    }

    private void appendTabToToolTip(Component c, StringBuilder sb) {
        JPanel rvp;
        if (c instanceof JPanel && (rvp = (JPanel)c).getToolTipText() != null) {
            sb.append("<br>&nbsp;&nbsp;");
            sb.append(StringUtils.escapeHTML((String)rvp.getToolTipText()));
            sb.append("&nbsp;");
        }
    }

    private class PanelPropL
    implements PropertyChangeListener {
        private PanelPropL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getSource() instanceof JPanel) || evt.getPropertyName() == null) {
                return;
            }
            JPanel jp = (JPanel)evt.getSource();
            int index = ResultView.this.tabs.indexOfComponent(jp);
            if (index == -1) {
                if (ResultView.this.singlePanel.getComponentCount() == 0 || jp != ResultView.this.singlePanel.getComponents()[0]) {
                    jp.removePropertyChangeListener(this);
                }
                return;
            }
            switch (evt.getPropertyName()) {
                case "name": {
                    ResultView.this.tabs.setTitleAt(index, jp.getName());
                    break;
                }
                case "ToolTipText": {
                    ResultView.this.tabs.setToolTipTextAt(index, jp.getToolTipText());
                }
            }
        }
    }

    private static class CurrentLookupProvider
    implements Lookup.Provider {
        private Lookup currentLookup = Lookup.EMPTY;

        private CurrentLookupProvider() {
        }

        public void setLookup(Lookup lookup) {
            this.currentLookup = lookup;
        }

        public Lookup getLookup() {
            return this.currentLookup;
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultView.this.removePanel(null);
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultView.this.closeAll(false);
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResultView.this.closeAll(true);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            ResultView.this.pop.show((Component)((Object)ResultView.this), e.getX(), e.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("close".equals(evt.getPropertyName())) {
                ResultView.this.removePanel((JPanel)evt.getNewValue());
            }
        }
    }

    @Deprecated
    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return null;
        }
    }
}

