/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.SearchController;
import org.graalvm.visualizer.search.SearchEvent;
import org.graalvm.visualizer.search.SearchListener;
import org.graalvm.visualizer.search.SearchResultColumns;
import org.graalvm.visualizer.search.SearchResultsEvent;
import org.graalvm.visualizer.search.SearchResultsListener;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.AbstractSearchResultsPanelBase;
import org.graalvm.visualizer.search.ui.Bundle;
import org.graalvm.visualizer.search.ui.RootSwitchNode;
import org.graalvm.visualizer.search.ui.SearchResultOptions;
import org.graalvm.visualizer.util.swing.ActionUtils;
import org.netbeans.api.actions.Openable;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RowModel;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.TopologicalSortException;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public class ResultViewPanel
extends JPanel
implements SearchListener,
SearchResultsListener,
PropertyChangeListener {
    private final OutlineView outlineView;
    private final Results resultsPane;
    private final SearchController controller;
    private SearchResultsModel currentModel;
    private boolean init;
    private SearchResultsListener wsrl;
    private SearchListener wsl;
    private final SearchResultColumns columnsConfig;
    private final PL tcLookup;
    private final InstanceContent viewContent = new InstanceContent();
    private final SearchResultOptions resultOptions = new SearchResultOptions();
    private NodeTreeModel capturedNodeModel;
    private Method refAllColumns;
    private Method refCreateColumn;
    private JTextField graphName;
    private JPanel headerPanel;
    private JLabel lGraph;
    private JLabel lScope;
    private JTextField scopeName;

    public ResultViewPanel(SearchController controller) {
        this.initComponents();
        this.tcLookup = new PL();
        this.viewContent.set(Arrays.asList(controller, this.resultOptions), null);
        this.columnsConfig = (SearchResultColumns)Lookup.getDefault().lookup(SearchResultColumns.class);
        this.outlineView = new OutlineView(Bundle.LABEL_GraphNodeIdColumn()){

            protected OutlineModel createOutlineModel(NodeTreeModel treeModel, RowModel rowModel, String label) {
                ResultViewPanel.this.capturedNodeModel = treeModel;
                return super.createOutlineModel(treeModel, rowModel, label);
            }
        };
        this.outlineView.getOutline().setRootVisible(false);
        this.outlineView.getOutline().setAutoCreateColumnsFromModel(false);
        TableColumn tc = this.outlineView.getOutline().getColumnModel().getColumn(0);
        tc.setIdentifier("0");
        tc.setPreferredWidth((int)this.columnsConfig.getColumnRelativeSize("0") * 10000);
        AbstractLookup c = new AbstractLookup((AbstractLookup.Content)this.viewContent);
        this.tcLookup.doSetLookups(new Lookup[]{c});
        this.resultsPane = new Results();
        this.add((Component)this.resultsPane, "Center");
        this.tcLookup.doSetLookups(new Lookup[]{this.resultsPane.getLookup(), c});
        this.controller = controller;
        this.outlineView.setVerticalScrollBarPolicy(22);
        this.outlineView.setPopupAllowed(true);
        this.outlineView.getOutline().setColumnHidingAllowed(true);
        this.setModel(controller.getResults());
        this.resultsPane.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public Lookup getLookup() {
        return this.tcLookup;
    }

    private void updateTableColumns() {
        List visibleCurrentOrder;
        HashSet<String> allProperties = new HashSet<String>(this.currentModel.getAllPropertyNames());
        allProperties.add("graph");
        ETableColumnModel colModel = (ETableColumnModel)this.outlineView.getOutline().getColumnModel();
        ArrayList<String> existingColumns = new ArrayList<String>();
        for (TableColumn tc : this.getAllColumns(colModel)) {
            existingColumns.add(tc.getIdentifier().toString());
        }
        allProperties.removeAll(existingColumns);
        HashMap<String, Collection<Object>> sortEdges = new HashMap<String, Collection<Object>>(existingColumns.size());
        for (int i = 1; i < existingColumns.size(); ++i) {
            ArrayList<String> followers = new ArrayList<String>();
            followers.add((String)existingColumns.get(i));
            sortEdges.put((String)existingColumns.get(i - 1), followers);
        }
        ArrayList<String> defaultVisible = new ArrayList<String>(this.columnsConfig.getDefaultVisibleColumns());
        try {
            visibleCurrentOrder = BaseUtilities.topologicalSort(defaultVisible, sortEdges);
        }
        catch (TopologicalSortException ex) {
            visibleCurrentOrder = ex.partialSort();
        }
        for (int i = 1; i < visibleCurrentOrder.size(); ++i) {
            String preceding = (String)visibleCurrentOrder.get(i - 1);
            String next = (String)visibleCurrentOrder.get(i);
            List followers = (List)sortEdges.get(preceding);
            if (followers != null) {
                if (followers.contains(next)) continue;
                followers.add(next);
                continue;
            }
            sortEdges.put(preceding, Collections.singleton(next));
        }
        if (existingColumns.containsAll(allProperties)) {
            return;
        }
        ArrayList<String> totalNewOrdering = new ArrayList<String>(existingColumns);
        totalNewOrdering.addAll(allProperties);
        try {
            totalNewOrdering = new ArrayList(BaseUtilities.topologicalSort(totalNewOrdering, sortEdges));
        }
        catch (TopologicalSortException ex) {
            totalNewOrdering = new ArrayList(ex.partialSort());
        }
        ArrayList<String> toHide = new ArrayList<String>();
        for (TableColumn c : this.getAllColumns(colModel)) {
            if (!colModel.isColumnHidden(c)) continue;
            colModel.setColumnHidden(c, false);
            toHide.add(c.getIdentifier().toString());
        }
        for (int idx = 0; idx < totalNewOrdering.size(); ++idx) {
            int curIndex;
            String cn = (String)totalNewOrdering.get(idx);
            if (!existingColumns.contains(cn)) {
                this.outlineView.addPropertyColumn(cn, cn);
                int modelIndex = this.outlineView.getOutline().getModel().getColumnCount() - 1;
                ETableColumn nc = this.createColumn(modelIndex, this.outlineView.getOutline());
                nc.setIdentifier((Object)cn);
                nc.setHeaderValue((Object)cn);
                this.outlineView.getOutline().getColumnModel().addColumn((TableColumn)nc);
                curIndex = colModel.getColumnIndex((Object)cn);
                if (curIndex == -1) continue;
                if (!defaultVisible.contains(cn)) {
                    toHide.add(cn);
                }
            } else {
                curIndex = colModel.getColumnIndex((Object)cn);
            }
            if (curIndex == idx) continue;
            colModel.moveColumn(curIndex, idx);
        }
        for (String cn : toHide) {
            int idx = colModel.getColumnIndex((Object)cn);
            if (idx == -1) continue;
            colModel.setColumnHidden(colModel.getColumn(idx), true);
        }
        this.seInitialColumnSizes(allProperties);
    }

    private void seInitialColumnSizes(Collection<String> columnIds) {
        String id;
        ETableColumn ecol;
        int i;
        ETableColumnModel colModel = (ETableColumnModel)this.outlineView.getOutline().getColumnModel();
        float totalWidth = 0.0f;
        for (i = 0; i < colModel.getColumnCount(); ++i) {
            ecol = (ETableColumn)colModel.getColumn(i);
            id = ecol.getIdentifier().toString();
            if (columnIds.contains(id)) continue;
            totalWidth += (float)ecol.getPreferredWidth();
        }
        for (i = 0; i < colModel.getColumnCount(); ++i) {
            ecol = (ETableColumn)colModel.getColumn(i);
            id = ecol.getIdentifier().toString();
            if (!columnIds.contains(id)) continue;
            float w = this.columnsConfig.getColumnRelativeSize(id);
            ecol.setPreferredWidth((int)w * 10000);
        }
    }

    private ETableColumn createColumn(int index, Outline out) {
        try {
            if (this.refCreateColumn == null) {
                this.refCreateColumn = Outline.class.getDeclaredMethod("createColumn", Integer.TYPE);
                this.refCreateColumn.setAccessible(true);
            }
            return (ETableColumn)this.refCreateColumn.invoke((Object)out, index);
        }
        catch (ReflectiveOperationException ex) {
            return new ETableColumn(index, (ETable)out);
        }
    }

    private List<TableColumn> getAllColumns(ETableColumnModel model) {
        try {
            if (this.refAllColumns == null) {
                this.refAllColumns = ETableColumnModel.class.getDeclaredMethod("getAllColumns", new Class[0]);
                this.refAllColumns.setAccessible(true);
            }
            return (List)this.refAllColumns.invoke((Object)model, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            return Collections.list(model.getColumns());
        }
    }

    private void updateNameAndTooltip() {
        this.setName(this.controller.getTitle());
        this.setToolTipText(this.controller.getCriteria().toDisplayString(false));
        this.scopeName.setText(this.controller.getGraphContainer().getName());
        this.graphName.setText(this.controller.getInitialGraph().getName());
        if (this.controller.pendingSearch().isFinished()) {
            this.resultsPane.enableStop(false);
        }
    }

    @Override
    public void searchStarted(SearchEvent event) {
        this.setModel(event.getModel());
        this.resultsPane.enableStop(true);
    }

    @Override
    public void searchFinished(SearchEvent event) {
        this.resultsPane.enableStop(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.init) {
            return;
        }
        this.setModel(this.controller.getResults());
        this.wsl = (SearchListener)WeakListeners.create(SearchListener.class, (EventListener)this, (Object)this.controller);
        this.controller.addSearchListener(this.wsl);
        SwingUtilities.invokeLater(this::updateNameAndTooltip);
    }

    @Override
    public void propertiesChanged(SearchResultsEvent event) {
        SwingUtilities.invokeLater(this::updateTableColumns);
    }

    private void setModel(SearchResultsModel model) {
        Object root;
        if (model == this.currentModel) {
            this.updateNameAndTooltip();
            return;
        }
        if (this.currentModel != null && this.wsrl != null) {
            this.currentModel.removeSearchResultsListener(this.wsrl);
        }
        if (model != null) {
            this.wsrl = (SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)model);
            model.addSearchResultsListener(this.wsrl);
            root = new RootSwitchNode(this.outlineView.getOutline(), this.resultsPane.getExplorerManager(), this.capturedNodeModel, this.controller.getGraphContainer(), model);
        } else {
            root = new AbstractNode(Children.LEAF);
        }
        this.resultsPane.getExplorerManager().setRootContext((Node)root);
        this.currentModel = model;
        this.updateTableColumns();
        this.updateNameAndTooltip();
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.lScope = new JLabel();
        this.scopeName = new JTextField();
        this.lGraph = new JLabel();
        this.graphName = new JTextField();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.lScope, (String)NbBundle.getMessage(ResultViewPanel.class, (String)"ResultViewPanel.lScope.text"));
        this.scopeName.setEditable(false);
        this.scopeName.setText(NbBundle.getMessage(ResultViewPanel.class, (String)"ResultViewPanel.scopeName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lGraph, (String)NbBundle.getMessage(ResultViewPanel.class, (String)"ResultViewPanel.lGraph.text"));
        this.graphName.setEditable(false);
        this.graphName.setText(NbBundle.getMessage(ResultViewPanel.class, (String)"ResultViewPanel.graphName.text"));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lScope).addGap(4, 4, 4).addComponent(this.scopeName, -1, 223, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lGraph).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphName, -1, 259, Short.MAX_VALUE).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lScope).addComponent(this.scopeName, -2, -1, -2).addComponent(this.lGraph).addComponent(this.graphName, -2, -1, -2))));
        this.add((Component)this.headerPanel, "First");
    }

    static class PL
    extends ProxyLookup {
        PL() {
        }

        public void doSetLookups(Lookup ... proxies) {
            super.setLookups(proxies);
        }
    }

    class Results
    extends AbstractSearchResultsPanelBase {
        public Results() {
            this.getContentPanel().add((Component)this.getOutlineView());
            this.initActions();
        }

        protected void initActions() {
            Action open = ActionUtils.findAction((String)"Diagram", (String)"org.graalvm.visualizer.search.gotonode", (Lookup)this.getLookup());
            this.getOutlineView().getOutline().getActionMap().put("select-node", open);
            this.getOutlineView().setDefaultActionAllowed(true);
        }

        @Override
        protected void initToolbar() {
            super.initToolbar();
            ActionUtils.addToolbarAction((JToolBar)this.getToolBar(), (Action)Actions.forID((String)"Diagram", (String)"org.graalvm.visualizer.search.extractnodes"), (ActionMap)this.getActionMap(), (Lookup)ResultViewPanel.this.tcLookup, (boolean)false);
            ActionUtils.addToolbarAction((JToolBar)this.getToolBar(), (Action)Actions.forID((String)"Diagram", (String)"org.graalvm.visualizer.search.gotonode"), (ActionMap)this.getActionMap(), (Lookup)ResultViewPanel.this.tcLookup, (boolean)false);
            ActionUtils.addToolbarAction((JToolBar)this.getToolBar(), (Action)Actions.forID((String)"Edit", (String)"org.openide.actions.DeleteAction"), (ActionMap)this.getActionMap(), (Lookup)ResultViewPanel.this.tcLookup, (boolean)false);
            ActionUtils.addToolbarAction((JToolBar)this.getToolBar(), (Action)Actions.forID((String)"Search", (String)"org.graalvm.isualizer.search.ui.ExtendSearchAction.Forward"), (ActionMap)this.getActionMap(), (Lookup)ResultViewPanel.this.tcLookup, (boolean)false);
            ActionUtils.addToolbarAction((JToolBar)this.getToolBar(), (Action)Actions.forID((String)"Search", (String)"org.graalvmvisualizer.search.ui.ExtendSearchAction.Backward"), (ActionMap)this.getActionMap(), (Lookup)ResultViewPanel.this.tcLookup, (boolean)false);
        }

        @Override
        protected OutlineView getOutlineView() {
            return ResultViewPanel.this.outlineView;
        }

        @Override
        protected boolean isDetailNode(Node n) {
            return n.getLookup().lookup(NodeResultItem.class) != null;
        }

        @Override
        protected void onDetailShift(Node n) {
            super.onDetailShift(n);
            Openable oo = (Openable)n.getLookup().lookup(Openable.class);
            if (oo != null) {
                oo.open();
            }
        }

        void enableStop(boolean enable) {
            if (enable) {
                this.showStopButton();
                this.btnStopRefresh.setEnabled(true);
            } else {
                this.btnStopRefresh.setEnabled(false);
            }
        }

        @Override
        protected void terminateSearch() {
            ResultViewPanel.this.controller.pendingSearch().cancel();
        }
    }
}

