/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.SearchResultsEvent;
import org.graalvm.visualizer.search.SearchResultsListener;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.ui.GraphNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class ResultsGraphChildren
extends Children.Keys<GraphItem>
implements SearchResultsListener {
    private final GraphContainer container;
    private final SearchResultsModel model;
    private SearchResultsListener wl;

    public ResultsGraphChildren(GraphContainer container, SearchResultsModel model) {
        this.model = model;
        this.container = container;
        this.wl = (SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)model);
        model.addSearchResultsListener(this.wl);
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.model.removeSearchResultsListener(this.wl);
        super.removeNotify();
    }

    protected void addNotify() {
        super.addNotify();
        if (this.wl == null) {
            this.wl = (SearchResultsListener)WeakListeners.create(SearchResultsListener.class, (EventListener)this, (Object)this.model);
        }
    }

    @Override
    public void parentsChanged(SearchResultsEvent event) {
        this.refreshKeys();
    }

    private void refreshKeys() {
        ArrayList parents = new ArrayList(this.container.getGraphs());
        ArrayList<GraphItem> items = new ArrayList<GraphItem>(this.model.getParents());
        Collections.sort(items, (a, b) -> {
            int i2;
            int i1 = parents.indexOf(a.getData());
            if (i1 != (i2 = parents.indexOf(b.getData()))) {
                return i1 - i2;
            }
            if (a.getData() == b.getData()) {
                return 0;
            }
            return a.hashCode() - b.hashCode();
        });
        this.setKeys(items);
    }

    protected Node[] createNodes(GraphItem t) {
        return new Node[]{new GraphNode(this.model, t)};
    }
}

