/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search.ui.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.search.SearchController;
import org.graalvm.visualizer.search.SearchEvent;
import org.graalvm.visualizer.search.SearchListener;
import org.openide.util.WeakListeners;

public abstract class ExtendSearchAction
extends AbstractAction
implements SearchListener {
    private final boolean previous;
    private final SearchController ctrl;

    ExtendSearchAction(SearchController ctrl, boolean previous) {
        this.ctrl = ctrl;
        this.previous = previous;
        if (ctrl != null) {
            ctrl.addSearchListener((SearchListener)WeakListeners.create(SearchListener.class, (EventListener)this, (Object)ctrl));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.ctrl.canSearch(this.previous);
    }

    @Override
    public void finished(SearchEvent ev) {
        this.setEnabled(this.ctrl.canSearch(this.previous));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean stopAtFirst = (e.getModifiers() & 1) == 0;
        this.ctrl.extendSearch(this.previous, stopAtFirst);
    }

    public static final class Backward
    extends ExtendSearchAction {
        public static final String ID = "org.graalvmvisualizer.search.ui.ExtendSearchAction.Backward";

        public Backward(SearchController ctrl) {
            super(ctrl, true);
        }
    }

    public static final class Forward
    extends ExtendSearchAction {
        public static final String ID = "org.graalvm.isualizer.search.ui.ExtendSearchAction.Forward";

        public Forward(SearchController ctrl) {
            super(ctrl, false);
        }
    }
}

