/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.DiagramItem;
import org.graalvm.visualizer.layout.Cluster;

public final class Block
implements Cluster,
DiagramItem {
    private final Diagram diagram;
    private final InputBlock inputBlock;
    private Rectangle bounds;
    private boolean visible;

    public Block(InputBlock inputBlock, Diagram diagram) {
        this.inputBlock = inputBlock;
        this.diagram = diagram;
        this.visible = inputBlock.getNodes().isEmpty();
    }

    public Cluster getOuter() {
        return null;
    }

    public InputBlock getInputBlock() {
        return this.inputBlock;
    }

    public Set<? extends Cluster> getSuccessors() {
        HashSet<Block> succs = new HashSet<Block>();
        for (InputBlock b : this.inputBlock.getSuccessors()) {
            succs.add(this.diagram.getBlock(b));
        }
        return succs;
    }

    @Override
    public void setBounds(Rectangle r) {
        this.bounds = r;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int compareTo(Cluster o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.inputBlock.getName();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
    }

    @Override
    public Point getPosition() {
        return this.bounds == null ? new Point(0, 0) : this.bounds.getLocation();
    }

    @Override
    public void setPosition(Point pt) {
        if (this.bounds == null) {
            this.bounds = new Rectangle(pt);
        } else {
            this.bounds.setLocation(pt);
        }
    }
}

