/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.Source;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;
import org.graalvm.visualizer.util.StringUtils;

public abstract class Slot
implements Port,
Source.Provider,
Properties.Provider {
    private int wantedIndex;
    private final Source source;
    protected List<Connection> connections;
    private InputNode associatedNode;
    private final Figure figure;
    private Color color;
    private String text;
    private String shortName;
    private int position;
    public static final Comparator<Slot> slotIndexComparator = new Comparator<Slot>(){

        @Override
        public int compare(Slot o1, Slot o2) {
            return o1.wantedIndex - o2.wantedIndex;
        }
    };
    public static final Comparator<Slot> slotFigureComparator = new Comparator<Slot>(){

        @Override
        public int compare(Slot o1, Slot o2) {
            return o1.figure.getId() - o2.figure.getId();
        }
    };

    protected Slot(Figure figure, int wantedIndex) {
        this.figure = figure;
        this.connections = new ArrayList<Connection>(2);
        this.source = new Source();
        this.wantedIndex = wantedIndex;
        this.text = "";
        this.shortName = "";
        assert (figure != null);
    }

    void setPosition(int pos) {
        this.position = pos;
    }

    public int getPosition() {
        return this.position;
    }

    public <T extends Slot> T copySlot(Figure f) {
        Slot s = this.copyInto(f);
        return (T)s.replaceFrom(this);
    }

    protected abstract Slot copyInto(Figure var1);

    protected Slot replaceFrom(Slot copyFrom) {
        this.wantedIndex = copyFrom.getWantedIndex();
        this.color = copyFrom.getColor();
        this.text = copyFrom.getText();
        this.associatedNode = copyFrom.getAssociatedNode();
        this.source.addSourceNodes(copyFrom.getSource());
        this.shortName = copyFrom.shortName;
        return this;
    }

    public Properties getProperties() {
        Properties p = Properties.newProperties();
        if (this.source.getSourceNodes().size() > 0) {
            for (InputNode n : this.source.getSourceNodes()) {
                p.add(n.getProperties());
            }
        } else {
            p.setProperty("name", (Object)"Slot");
            p.setProperty("figure", this.figure.getProperties().get("name", String.class));
            p.setProperty("connectionCount", (Object)Integer.toString(this.connections.size()));
        }
        return p;
    }

    public InputNode getAssociatedNode() {
        return this.associatedNode;
    }

    public void setAssociatedNode(InputNode node) {
        this.associatedNode = node;
    }

    public int getWidth() {
        if (this.shortName == null || this.shortName.length() <= 1) {
            return Figure.SLOT_WIDTH;
        }
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics g = image.getGraphics();
        g.setFont(Diagram.getSlotFont().deriveFont(1));
        FontMetrics metrics = g.getFontMetrics();
        return Math.max(Figure.SLOT_WIDTH, metrics.stringWidth(this.shortName) + 6);
    }

    public int getWantedIndex() {
        return this.wantedIndex;
    }

    public Source getSource() {
        return this.source;
    }

    public String getText() {
        return this.text;
    }

    public void setShortName(String s) {
        assert (s != null);
        this.shortName = s;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getToolTipText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.text);
        for (InputNode n : this.getSource().getSourceNodes()) {
            sb.append(StringUtils.escapeHTML((String)("Node (ID=" + n.getId() + "): " + (String)n.getProperties().get("name", String.class))));
            sb.append("<br>");
        }
        return sb.toString();
    }

    public boolean shouldShowName() {
        return this.getShortName() != null && this.getShortName().length() > 0;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        this.text = s;
    }

    public Figure getFigure() {
        assert (this.figure != null);
        return this.figure;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public List<Connection> getConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public void removeAllConnections() {
        this.removeAllConnections(null);
    }

    public void removeAllConnections(HashSet<Object> cleaned) {
        ArrayList<Connection> connectionsCopy = new ArrayList<Connection>(this.connections);
        for (Connection c : connectionsCopy) {
            c.remove(cleaned);
        }
    }

    public Vertex getVertex() {
        return this.figure;
    }

    void cleanDeletedFigures(HashSet<Object> cleaned) {
        Figure input = this.getFigure();
        if (!input.isDeleted() && cleaned.add(input)) {
            input.cleanDeletedFigures();
        }
        if (cleaned.add(this)) {
            this.connections.removeIf(x -> x.getInputSlot().getFigure().isDeleted() || x.getOutputSlot().getFigure().isDeleted());
        }
    }
}

