/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualizer.coordinator.actions.Bundle;
import org.graalvm.visualizer.coordinator.actions.SaveAsAction;
import org.graalvm.visualizer.coordinator.impl.FileImporter;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class ImportAction
extends SystemAction {
    private static final Logger LOG = Logger.getLogger(ImportAction.class.getName());

    public static FileFilter getZipFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String fn = f.getName().toLowerCase(Locale.ENGLISH);
                return fn.endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return Bundle.MSG_BIGV_Description_ZIP();
            }
        };
    }

    public void actionPerformed(ActionEvent e) {
        GraalSettings settings = GraalSettings.obtain();
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File dir;
                File selectedFile = this.getSelectedFile();
                if (selectedFile != null && (dir = FileUtil.normalizeFile((File)selectedFile)).exists() && dir.isFile()) {
                    super.approveSelection();
                }
            }
        };
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(SaveAsAction.getFileFilter());
        fc.addChoosableFileFilter(ImportAction.getZipFilter());
        fc.setCurrentDirectory(new File(settings.getDirectory()));
        fc.setMultiSelectionEnabled(true);
        if (fc.showOpenDialog(null) == 0) {
            for (File file : fc.getSelectedFiles()) {
                File dir = file;
                if (!dir.isDirectory()) {
                    dir = dir.getParentFile();
                }
                settings.setDirectory(dir.getAbsolutePath());
                boolean ok = false;
                for (FileFilter ff : fc.getChoosableFileFilters()) {
                    if (!ff.accept(file)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    String war = file.getName();
                    war = Bundle.WAR_WrongExtension(war.substring(war.lastIndexOf(".") + 1, war.length()));
                    JOptionPane.showMessageDialog(null, Bundle.WAR_PropperExtension(), war, 2);
                    return;
                }
                try {
                    FileImporter.asyncImportDocument(file.toPath(), true, true, null);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)ex, (String)Bundle.ERR_OpeningFile(file.toPath(), ex.toString())));
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(ImportAction.class, (String)"CTL_ImportAction");
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/import.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

