/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.DataSource;
import jdk.graal.compiler.graphio.parsing.GraphParser;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import org.graalvm.visualizer.coordinator.OutlineTopComponent;
import org.graalvm.visualizer.coordinator.actions.ImportAction;
import org.graalvm.visualizer.coordinator.actions.SaveAsAction;
import org.graalvm.visualizer.coordinator.impl.Bundle;
import org.graalvm.visualizer.coordinator.impl.ManagedSessionImpl;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.graalvm.visualizer.data.serialization.lazy.CachedContent;
import org.graalvm.visualizer.data.serialization.lazy.CancelableSource;
import org.graalvm.visualizer.data.serialization.lazy.FileContent;
import org.graalvm.visualizer.data.serialization.lazy.ScanningModelBuilder;
import org.graalvm.visualizer.data.serialization.lazy.ZipFileContent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class FileImporter {
    private static final Logger LOG = Logger.getLogger(FileImporter.class.getName());
    private static final int WORKUNITS = 10000;
    private static final RequestProcessor LOADER_RP = new RequestProcessor(ImportAction.class.getName(), 10);

    public static FileFilter getFileFilter() {
        return SaveAsAction.getFileFilter();
    }

    public static void asyncImportDocument(Path path, boolean reportErrors, boolean addToMainDocument, BiConsumer<GraphDocument, IOException> callback) throws IOException {
        Callable<GraphDocument> c = FileImporter.createDocumentImporter(path, reportErrors, addToMainDocument, callback);
        if (c == null) {
            return;
        }
        LOADER_RP.post(() -> {
            try {
                c.call();
                SwingUtilities.invokeLater(() -> {
                    OutlineTopComponent component = OutlineTopComponent.findInstance();
                    if (component != null) {
                        component.requestActive();
                    }
                });
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
    }

    static Callable<GraphDocument> createDocumentImporter(Path path, boolean reportErrors, boolean addToMainDocument, BiConsumer<GraphDocument, IOException> callback) throws IOException {
        FileChannel closeChannel;
        ZipFileContent content;
        Mon monitor;
        Path fname = path.getFileName();
        if (fname == null) {
            throw new IllegalArgumentException(path.toString());
        }
        File id = path.toFile();
        String fn = fname.toString().toLowerCase(Locale.ENGLISH);
        if (fn.endsWith(".zip")) {
            ZipFileContent zc = new ZipFileContent(path, Utilities.activeReferenceQueue());
            monitor = new Mon((SeekableByteChannel)zc);
            content = zc;
            closeChannel = null;
        } else {
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            content = new FileContent(path, channel);
            monitor = new Mon(channel);
            closeChannel = channel;
        }
        FileObject fo = FileUtil.toFileObject((File)path.toFile());
        if (fo == null) {
            return null;
        }
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)("Opening file " + fname), (Cancellable)monitor);
        monitor.setHandle(handle);
        handle.start(10000);
        CancelableSource src = new CancelableSource((Object)id, (ParseMonitor)monitor, (ReadableByteChannel)content);
        ManagedSessionImpl targetDocument = new ManagedSessionImpl(fo);
        ScanningModelBuilder bld = new ScanningModelBuilder((BinarySource)src, (CachedContent)content, (GraphDocument)targetDocument, (ParseMonitor)monitor, (ScheduledExecutorService)LOADER_RP);
        bld.setDocumentId((Object)id);
        BinaryReader parser = new BinaryReader((DataSource)src, (Builder)bld);
        long startTime = System.currentTimeMillis();
        return () -> FileImporter.lambda$createDocumentImporter$2(targetDocument, (GraphParser)parser, reportErrors, path, closeChannel, handle, callback, startTime);
    }

    private static void reportException(Path path, Throwable ex) {
        if (ex instanceof InterruptedIOException) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_LoadCancelled(path), 1));
        } else {
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)ex, (String)Bundle.ERR_ReadingFile(path, ex.toString())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ GraphDocument lambda$createDocumentImporter$2(ManagedSessionImpl targetDocument, GraphParser parser, boolean reportErrors, Path path, Channel closeChannel, ProgressHandle handle, BiConsumer callback, long startTime) throws Exception {
        IOException exc = null;
        try (GraphDocument.DocumentLock lock = targetDocument.writeLock(null, null);){
            lock.trackModifications(false);
            parser.parse();
        }
        catch (AssertionError e) {
            if (reportErrors) {
                FileImporter.reportException(path, (Throwable)((Object)e));
            }
            exc = new IOException((Throwable)((Object)e));
        }
        catch (IOException ex) {
            if (reportErrors) {
                FileImporter.reportException(path, ex);
            }
            exc = ex;
        }
        finally {
            try {
                if (closeChannel != null) {
                    closeChannel.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            handle.finish();
        }
        if (exc != null && !reportErrors) {
            throw exc;
        }
        if (callback != null) {
            callback.accept(targetDocument, exc);
        }
        if (targetDocument.getProperties().getString("name", null) == null) {
            targetDocument.getProperties().setProperty("name", (Object)SessionManagerImpl.getInstance().getSessionDisplayName(targetDocument, false));
        }
        SessionManagerImpl.getInstance().addSession(targetDocument);
        long stop = System.currentTimeMillis();
        LOG.log(Level.INFO, "Loaded in " + path + " in " + (double)(stop - startTime) / 1000.0 + " seconds");
        return targetDocument;
    }

    static class Mon
    implements ParseMonitor,
    Cancellable {
        final SeekableByteChannel channel;
        final AtomicBoolean cancelFlag = new AtomicBoolean();
        ProgressHandle handle;

        public Mon(SeekableByteChannel channel) {
            this.channel = channel;
        }

        synchronized void setHandle(ProgressHandle h) {
            this.handle = h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateProgress() {
            try {
                int prog = (int)(10000.0 * (double)this.channel.position() / (double)this.channel.size());
                if (prog > 10000) {
                    prog = 10000;
                }
                Mon mon = this;
                synchronized (mon) {
                    this.handle.progress(prog);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setState(String state) {
            this.updateProgress();
            this.handle.progress(state);
        }

        public boolean isCancelled() {
            return this.cancelFlag.get();
        }

        public boolean cancel() {
            this.cancelFlag.set(true);
            return true;
        }

        public void reportError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
            SessionManagerImpl.reportLoadingError(parents, parentNames, name, errorMessage);
        }
    }
}

