/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.coordinator.impl.ManagedSessionImpl;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;

public class VmUuidSessionFactory
implements DocumentFactory {
    private final SessionManagerImpl sessionManager;
    private GraphDocument lastDocument;

    public VmUuidSessionFactory(SessionManagerImpl sessionManager) {
        this.sessionManager = sessionManager;
    }

    public VmUuidSessionFactory() {
        this(SessionManagerImpl.getInstance());
    }

    public synchronized GraphDocument documentFor(Object id, Properties props, Group data) {
        Properties merge = Properties.newProperties((Properties)props);
        if (data != null) {
            merge.add(data.getProperties());
            merge.remove("type");
            merge.remove("graph");
        }
        String cmdLine = merge.getString("sun.java.command", null);
        String jvmargs = merge.getString("jvmArguments", "");
        String uuid = merge.getString("vm.uuid", null);
        GraphDocument doc = null;
        if (uuid == null && cmdLine == null) {
            String n = data.getName();
            if (n != null && n.startsWith("Truffle::")) {
                doc = this.lastDocument;
            }
            if (doc == null) {
                doc = this.sessionManager.getSingleDocument();
            }
        } else {
            String cmdLineKey = cmdLine + ":" + jvmargs;
            GraphDocument candidate = null;
            for (GraphDocument gd : this.sessionManager.getAppendableSessions()) {
                String c;
                if (uuid != null) {
                    String u = gd.getProperties().getString("vm.uuid", null);
                    if (!uuid.equalsIgnoreCase(u)) continue;
                    candidate = gd;
                    break;
                }
                if (cmdLine == null || !cmdLineKey.equals(c = gd.getProperties().getString("sun.java.command", null) + ":" + gd.getProperties().getString("jvmArguments", ""))) continue;
                candidate = gd;
            }
            if (candidate != null) {
                this.lastDocument = candidate;
                return candidate;
            }
            doc = new ManagedSessionImpl(id, merge);
            if (doc.getName() == null) {
                doc.getProperties().setProperty("name", (Object)SessionManagerImpl.getInstance().getSessionDisplayName(doc, false));
            }
            this.lastDocument = doc;
        }
        this.sessionManager.addSession(doc);
        return doc;
    }
}

