/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.ui;

import java.util.EventListener;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.java.impl.JavaLocationInfo;
import org.graalvm.visualizer.source.java.ui.Bundle;
import org.graalvm.visualizer.source.java.ui.LocationOpener;
import org.graalvm.visualizer.source.spi.LocationServices;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JavaStackFramePresenter
implements LocationServices {
    public Lookup createLookup(NodeStack.Frame frame) {
        final Location loc = frame.getLocation();
        final JavaLocationInfo javaInfo = (JavaLocationInfo)loc.getSpecificInfo(JavaLocationInfo.class);
        if (javaInfo == null) {
            return null;
        }
        String className = javaInfo.getClassName();
        int classDot = className.lastIndexOf(36);
        if (classDot == -1) {
            classDot = className.lastIndexOf(46);
        }
        final String simpleName = className.substring(classDot + 1);
        InstanceContent content = new InstanceContent();
        AbstractLookup nodeLookup = new AbstractLookup((AbstractLookup.Content)content);
        AbstractNode presentNode = new AbstractNode(Children.LEAF, (Lookup)nodeLookup){
            private FileRegistry.FileRegistryListener regListener;
            private FileRegistry.FileRegistryListener wL;

            public String getHtmlDisplayName() {
                String n = loc.getLine() > 0 ? Bundle.HtmlFormat_MethodName(simpleName, javaInfo.getMethodName(), loc.getLine()) : Bundle.HtmlFormat_MethodNameUnknownLine(simpleName, javaInfo.getMethodName());
                if (javaInfo.isResolved()) {
                    return n;
                }
                if (this.regListener == null) {
                    this.regListener = new L();
                    FileRegistry reg = FileRegistry.getInstance();
                    this.wL = (FileRegistry.FileRegistryListener)WeakListeners.create(FileRegistry.FileRegistryListener.class, (EventListener)this.regListener, (Object)reg);
                    reg.addFileRegistryListener(this.wL);
                }
                return Bundle.HtmlFormat_Unresolved(n);
            }

            class L
            implements FileRegistry.FileRegistryListener {
                L() {
                }

                public void filesResolved(FileRegistry.FileRegistryEvent ev) {
                    if (!ev.getResolvedKeys().contains(loc.getFile())) {
                        return;
                    }
                    ev.getRegistry().removeFileRegistryListener(wL);
                    this.fireDisplayNameChange(null, null);
                }
            }
        };
        if (javaInfo.getInvokedMethod() != null) {
            presentNode.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/methodCall.png");
        } else if (javaInfo.getVariableName() != null) {
            presentNode.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/fieldRef.png");
        } else {
            presentNode.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/executable.png");
        }
        LocationOpener opener = new LocationOpener(loc);
        content.add((Object)frame.getNode());
        content.add((Object)opener);
        content.add((Object)presentNode);
        content.add((Object)loc);
        content.add((Object)frame);
        content.add((Object)javaInfo);
        return nodeLookup;
    }
}

