/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.clientproject.api.util.ValidationUtilities;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class NewClientSideProject
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final String projectNameTemplate;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public NewClientSideProject(String projectNameTemplate) {
        assert (projectNameTemplate != null);
        this.projectNameTemplate = projectNameTemplate;
        this.initComponents();
        this.initProjectNameAndLocation();
    }

    private void initProjectNameAndLocation() {
        File projectLocation = ProjectChooser.getProjectsFolder();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        String projectName = this.projectNameTemplate;
        int index = 0;
        while (new File(projectLocation, projectName).exists()) {
            projectName = this.projectNameTemplate + ++index;
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
        this.updateProjectFolder();
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.projectNameTextField.getDocument().addDocumentListener(documentListener);
        this.projectLocationTextField.getDocument().addDocumentListener(documentListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public String getProjectLocation() {
        return this.projectLocationTextField.getText().trim();
    }

    public File getProjectDirectory() {
        return FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()));
    }

    public final void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getErrorMessage() {
        String error = this.validateProjectName();
        if (error != null) {
            return error;
        }
        error = this.validateProjectLocation();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateProjectName() {
        String projectName = this.getProjectName();
        if (projectName.isEmpty()) {
            return Bundle.ClientSideProject_error_name_missing();
        }
        return null;
    }

    private String validateProjectLocation() {
        File projLoc;
        File projectLocation = FileUtil.normalizeFile((File)new File(this.getProjectLocation()).getAbsoluteFile());
        if (!projectLocation.isDirectory()) {
            return Bundle.ClientSideProject_error_location_invalid();
        }
        File destFolder = this.getProjectDirectory();
        if (ClientSideProjectUtilities.isProject(destFolder)) {
            return Bundle.ClientSideProject_error_location_alreadyProject();
        }
        if (!ValidationUtilities.isValidFilename((File)destFolder)) {
            return Bundle.ClientSideProject_error_location_invalid();
        }
        for (projLoc = destFolder; projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return Bundle.ClientSideProject_error_location_notWritable();
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            return Bundle.ClientSideProject_error_location_invalid();
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            return Bundle.ClientSideProject_error_location_notEmpty();
        }
        return null;
    }

    void updateProjectFolder() {
        this.createdFolderTextField.setText(this.getProjectLocation() + File.separatorChar + this.getProjectName());
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(NewClientSideProject.class, (String)"NewClientSideProject.projectNameLabel.text"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(NewClientSideProject.class, (String)"NewClientSideProject.projectLocationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewClientSideProject.class, (String)"NewClientSideProject.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewClientSideProject.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(NewClientSideProject.class, (String)"NewClientSideProject.createdFolderLabel.text"));
        this.createdFolderTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.projectLocationLabel).addComponent(this.createdFolderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField, GroupLayout.Alignment.TRAILING).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING).addComponent(this.createdFolderTextField, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationLabel).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel).addComponent(this.createdFolderTextField, -2, -1, -2))));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File projectDir;
        File projDir;
        File workDir = null;
        String projectLocation = this.getProjectLocation();
        if (projectLocation != null && !projectLocation.isEmpty() && (projDir = new File(projectLocation)).isDirectory()) {
            workDir = projDir;
        }
        if (workDir == null) {
            workDir = ProjectChooser.getProjectsFolder();
        }
        if ((projectDir = new FileChooserBuilder(NewClientSideProject.class).setTitle(Bundle.ClientSideProject_dialog_location_title()).setDirectoriesOnly(true).setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true).showOpenDialog()) != null) {
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            NewClientSideProject.this.updateProjectFolder();
            NewClientSideProject.this.fireChange();
        }
    }
}

