/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.filter.profiles.FilterDefinition;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.util.ListenerSupport;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class FilterBridge
implements Filter,
FilterDefinition,
ChangedListener {
    final FilterProfile ops;
    final FileObject file;
    final FilterProvider source;
    private final ChangedEvent<Filter> event = new ChangedEvent((Object)this);
    final ProfileService profiles;
    private Filter lastDelegate;
    private final L l = new L();
    private ChangedListener weakCL;
    private final PL lookup = new PL();
    int hashCode = -1;

    public FilterBridge(FileObject f, FilterProfile ops, FilterProvider source, ProfileService srv) {
        this.ops = ops;
        this.file = f;
        this.source = source;
        this.profiles = srv;
        f.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.l, (Object)f));
        source.addChangeListener(WeakListeners.change((ChangeListener)this.l, (Object)source));
    }

    @Override
    public Filter getOriginalFilter() {
        FileObject link = (FileObject)this.file.getLookup().lookup(FileObject.class);
        for (Filter f : this.profiles.getDefaultProfile().getProfileFilters()) {
            FileObject ff = (FileObject)f.getLookup().lookup(FileObject.class);
            if (ff != link) continue;
            return f;
        }
        return this;
    }

    @Override
    public void setName(String newName) throws IOException {
        this.profiles.renameFilter(this, newName);
    }

    private Filter delegate() {
        Filter f = this.source.getFilter();
        if (f != null) {
            return this.changeDelegate(f);
        }
        return this.changeDelegate(Filter.NONE);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            return this.delegate().hashCode();
        }
        return this.hashCode;
    }

    private Filter updateDelegate() {
        Filter f = this.source.createFilter(false);
        if (f != null) {
            return this.changeDelegate(f);
        }
        return this.changeDelegate(Filter.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter changeDelegate(Filter delegate) {
        Filter old;
        FilterBridge filterBridge = this;
        synchronized (filterBridge) {
            if (delegate == this.lastDelegate) {
                return delegate;
            }
            old = this.lastDelegate;
            this.lastDelegate = delegate;
            if (old != null && this.weakCL != null) {
                old.getChangedEvent().removeListener((Object)this.weakCL);
            }
            this.weakCL = delegate != null ? ListenerSupport.addWeakListener((ChangedListener)this, (ChangedEvent)delegate.getChangedEvent()) : null;
        }
        if (delegate != null) {
            if (this.hashCode == -1) {
                this.hashCode = delegate.hashCode();
            }
            this.lookup.updateLookup(delegate.getLookup());
        }
        if (old != null) {
            this.event.fire();
        }
        return delegate;
    }

    public String getName() {
        return FilterBridge.file2Name(this.file);
    }

    static final String file2Name(FileObject f) {
        if (f != null) {
            try {
                return f.getFileSystem().getDecorator().annotateName(f.getName(), Collections.singleton(f));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return Filter.NONE.getName();
    }

    public Lookup getLookup() {
        this.delegate();
        return this.lookup;
    }

    public OpenCookie getEditor() {
        return (OpenCookie)this.getLookup().lookup(OpenCookie.class);
    }

    public ChangedEvent<Filter> getChangedEvent() {
        return this.event;
    }

    public Properties getProperties() {
        return this.delegate().getProperties();
    }

    public void applyWith(FilterEnvironment env) {
        this.delegate().applyWith(env);
    }

    public boolean cancel(FilterEnvironment d) {
        return this.delegate().cancel(d);
    }

    public void changed(Object source) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.event.fire();
        } else {
            SwingUtilities.invokeLater(() -> this.event.fire());
        }
    }

    public String toString() {
        return "FB[" + this.file.getPath() + ", impl = " + this.lastDelegate + "]";
    }

    class L
    extends FileChangeAdapter
    implements ChangeListener {
        L() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            super.fileAttributeChanged(fe);
            if ("displayName".equals(fe.getName())) {
                FilterBridge.this.getChangedEvent().fire();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            super.fileRenamed(fe);
            FilterBridge.this.getChangedEvent().fire();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FilterBridge.this.updateDelegate();
        }
    }

    class PL
    extends ProxyLookup {
        PL() {
        }

        void updateLookup(Lookup lkp) {
            FileObject f = FilterBridge.this.file;
            if (f == null) {
                this.setLookups(new Lookup[]{lkp});
            } else {
                this.setLookups(new Lookup[]{Lookups.fixed((Object[])new Object[]{f, FilterBridge.this, FilterBridge.this.ops}), lkp});
            }
        }
    }
}

