/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.filter.DataFilterSelector;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.Profiles;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.util.ListenerSupport;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class FilterProfileSelector
implements DataFilterSelector,
ChangeListener,
PropertyChangeListener {
    private final GraphViewer viewerService;
    private final ProfileService profileService;
    private final Map<TopComponent, FilterProfileSwitcher> stickyProfiles = new WeakHashMap<TopComponent, FilterProfileSwitcher>();

    public FilterProfileSelector() {
        this((GraphViewer)Lookup.getDefault().lookup(GraphViewer.class), (ProfileService)Lookup.getDefault().lookup(ProfileService.class), TopComponent.getRegistry());
    }

    FilterProfileSelector(GraphViewer viewers, ProfileService profiles, TopComponent.Registry tcreg) {
        this.viewerService = viewers;
        this.profileService = profiles;
        this.viewerService.addChangeListener((ChangeListener)this);
        tcreg.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.profileService.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (String)"selectedProfile", (Object)this.profileService));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.profileService) {
            if ("selectedProfile".equals(evt.getPropertyName())) {
                this.changeStickyProfile(this.profileService.getSelectedProfile());
            }
            return;
        }
        if (evt.getPropertyName() == null) {
            this.updateSelection();
        } else {
            switch (evt.getPropertyName()) {
                case "activated": 
                case "tcOpened": {
                    this.updateSelection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection() {
        FilterProfileSwitcher selected;
        TopComponent active = TopComponent.getRegistry().getActivated();
        if (active == null) {
            return;
        }
        InputGraphProvider igp = (InputGraphProvider)active.getLookup().lookup(InputGraphProvider.class);
        if (igp == null) {
            return;
        }
        FilterProfileSelector filterProfileSelector = this;
        synchronized (filterProfileSelector) {
            selected = this.stickyProfiles.get(active);
        }
        FilterProfile toSelect = selected.delegate;
        this.profileService.setSelectedProfile(toSelect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterSequence getFilterChain(InputGraph graph, GraphContainer parent, Lookup context) {
        TopComponent tc = (TopComponent)context.lookup(TopComponent.class);
        if (tc == null) {
            return this.profileService.getDefaultProfile().getSelectedFilters();
        }
        Group g = parent.getContentOwner();
        FilterProfile selected = null;
        FilterProfileSelector filterProfileSelector = this;
        synchronized (filterProfileSelector) {
            FilterProfileSwitcher p = this.stickyProfiles.get(tc);
            if (p != null) {
                return p;
            }
            GraphViewer vService = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
            List viewers = vService.getViewers();
            for (InputGraphProvider v : viewers) {
                TopComponent vtc = (TopComponent)v.getLookup().lookup(TopComponent.class);
                FilterProfileSwitcher sw = this.stickyProfiles.get(vtc);
                if (sw == null || sw.group != g || !Objects.equals(sw.type, graph.getGraphType())) continue;
                FilterProfileSwitcher blueprint = sw;
                selected = blueprint.delegate;
                break;
            }
        }
        if (selected == null) {
            List<FilterProfile> candidates = Profiles.selectProfiles(this.profileService.getProfiles(), graph, parent, context);
            selected = candidates.isEmpty() ? this.profileService.getDefaultProfile() : candidates.get(0);
        }
        FilterProfileSwitcher switcher = new FilterProfileSwitcher(g, graph.getGraphType(), selected);
        FilterProfileSelector filterProfileSelector2 = this;
        synchronized (filterProfileSelector2) {
            this.stickyProfiles.putIfAbsent(tc, switcher);
            return this.stickyProfiles.get(tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStickyProfile(FilterProfile newSelection) {
        FilterProfileSwitcher switcher;
        InputGraphProvider igp = this.viewerService.getActiveViewer();
        if (igp == null) {
            return;
        }
        TopComponent tc = (TopComponent)igp.getLookup().lookup(TopComponent.class);
        FilterProfileSelector filterProfileSelector = this;
        synchronized (filterProfileSelector) {
            switcher = this.stickyProfiles.get(tc);
        }
        if (switcher == null) {
            return;
        }
        switcher.setDelegate(newSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        List provs = this.viewerService.getViewers();
        HashSet<TopComponent> keys = new HashSet<TopComponent>();
        for (InputGraphProvider v : provs) {
            InputGraph gr = v.getGraph();
            GraphContainer c = v.getContainer();
            TopComponent tc = (TopComponent)v.getLookup().lookup(TopComponent.class);
            if (tc == null) continue;
            keys.add(tc);
        }
        FilterProfileSelector filterProfileSelector = this;
        synchronized (filterProfileSelector) {
            this.stickyProfiles.keySet().retainAll(keys);
        }
        SwingUtilities.invokeLater(this::updateSelection);
    }

    private static class FilterProfileSwitcher
    implements FilterSequence<FilterSequence>,
    FilterListener,
    ChangedListener<FilterChain> {
        private final ChangedEvent<FilterSequence> event = new ChangedEvent((Object)this);
        private final Group group;
        private final String type;
        private FilterProfile delegate;
        private FilterListener weakFilterL;
        private ChangedListener<FilterChain> weakChangeL;
        private List<FilterListener> listeners = null;

        public FilterProfileSwitcher(Group group, String type, FilterProfile delegate) {
            this.group = group;
            this.type = type;
            this.setDelegate(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDelegate(FilterProfile s) {
            FilterProfileSwitcher filterProfileSwitcher = this;
            synchronized (filterProfileSwitcher) {
                if (s == this.delegate) {
                    return;
                }
                if (this.delegate != null) {
                    if (this.weakFilterL != null) {
                        this.delegate.getSelectedFilters().removeFilterListener(this.weakFilterL);
                    }
                    this.delegate.getSelectedFilters().getChangedEvent().removeListener(this.weakChangeL);
                }
                this.delegate = s;
                if (s != null) {
                    ChangedListener cl;
                    this.weakChangeL = cl = ListenerSupport.addWeakListener((ChangedListener)this, (ChangedEvent)this.delegate.getSelectedFilters().getChangedEvent());
                    if (this.weakFilterL != null) {
                        this.attachFilterListener();
                    }
                }
            }
            this.event.fire();
        }

        private void attachFilterListener() {
            FilterListener fl = (FilterListener)WeakListeners.create(FilterListener.class, (EventListener)((Object)this), (Object)this.delegate);
            this.delegate.getSelectedFilters().addFilterListener(fl);
            this.weakFilterL = fl;
        }

        public ChangedEvent<FilterSequence> getChangedEvent() {
            return this.event;
        }

        public List getFilters() {
            return this.delegate.getSelectedFilters().getFilters();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFilterListener(FilterListener l) {
            FilterProfileSwitcher filterProfileSwitcher = this;
            synchronized (filterProfileSwitcher) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<FilterListener>();
                    this.attachFilterListener();
                }
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeFilterListener(FilterListener l) {
            FilterProfileSwitcher filterProfileSwitcher = this;
            synchronized (filterProfileSwitcher) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forward(FilterEvent e, BiConsumer<FilterListener, FilterEvent> method) {
            FilterListener[] ll;
            FilterProfileSwitcher filterProfileSwitcher = this;
            synchronized (filterProfileSwitcher) {
                if (this.listeners == null || this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new FilterListener[this.listeners.size()]);
            }
            FilterEvent e2 = new FilterEvent(e.getExecution(), (FilterSequence)this, e.getFilter(), e.getFilteredDiagram(), e.getExecutionError());
            for (int i = 0; i < ll.length; ++i) {
                method.accept(ll[i], e2);
            }
        }

        public void filterStart(FilterEvent e) {
            this.forward(e, FilterListener::filterStart);
        }

        public void filterEnd(FilterEvent e) {
            this.forward(e, FilterListener::filterEnd);
        }

        public void executionStart(FilterEvent e) {
            this.forward(e, FilterListener::executionStart);
        }

        public void executionEnd(FilterEvent e) {
            this.forward(e, FilterListener::executionEnd);
        }

        public void changed(FilterChain source) {
            this.event.fire();
        }
    }

    private static class Key
    extends WeakReference<Group>
    implements Runnable {
        private final Reference<TopComponent> refTC;
        private final String containerType;
        private final int hashRef;

        public Key(Group g, String type, TopComponent tc) {
            super(g, Utilities.activeReferenceQueue());
            this.refTC = new WeakReference<TopComponent>(tc);
            this.containerType = type;
            this.hashRef = g.hashCode();
        }

        @Override
        public void run() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Key k = (Key)o;
            if (!Objects.equals(this.containerType, k.containerType)) {
                return false;
            }
            Group g = (Group)this.get();
            Group kg = (Group)k.get();
            if (g == null || kg == null || !g.equals(kg)) {
                return false;
            }
            TopComponent tc = this.refTC.get();
            TopComponent ktc = k.refTC.get();
            return tc != null && ktc != null && tc.equals(ktc);
        }

        public int hashCode() {
            return this.hashRef << 7 ^ this.containerType.hashCode();
        }
    }
}

