/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter.profiles.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.visualizer.filter.CustomFilter;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.filter.Filters;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.impl.Bundle;
import org.graalvm.visualizer.filter.profiles.impl.FilterBridge;
import org.graalvm.visualizer.filter.profiles.impl.FilterProfileAdapter;
import org.graalvm.visualizer.filter.profiles.impl.LegacyFilterSynchronizer;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileStorage;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class FilterProfileServiceImpl
implements ProfileService,
ProfileStorage {
    private final Map<FileObject, E> profiles = new HashMap<FileObject, E>();
    private final PropertyChangeSupport prop = new PropertyChangeSupport(this);
    private final FileObject profilesRoot;
    private final FileObject defaultProfileFolder;
    private final FilterProfile defaultProfile;
    private List<FilterProfile> profileList = null;
    private final FileChangeListener fileL;
    private final Lookup myLookup;
    private final BiFunction<ProfileService, FileObject, FilterProfile> profileFactory;
    FilterProfile selectedProfile;
    Map<FileObject, Filter> file2Filter = new WeakHashMap<FileObject, Filter>();
    private boolean wasChanged;
    RequestProcessor.Task delayedRefresh;

    public FilterProfileServiceImpl() {
        this(FileUtil.getConfigFile((String)"IGV/FilterProfiles"), FileUtil.getConfigFile((String)"Filters"), null);
    }

    FilterProfileServiceImpl(FileObject root, FileObject defaultFolder, BiFunction<ProfileService, FileObject, FilterProfile> profileFactory) {
        this.profilesRoot = root;
        this.defaultProfileFolder = defaultFolder;
        if (profileFactory == null) {
            profileFactory = this::defaultCreateProfile;
        }
        this.profileFactory = profileFactory;
        this.selectedProfile = this.defaultProfile = this.createProfile(this.defaultProfileFolder);
        this.fileL = new FolderListener();
        this.profilesRoot.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.fileL, (Object)this.profilesRoot));
        this.myLookup = Lookups.fixed((Object[])new Object[]{this});
    }

    protected FilterProfile createProfile(FileObject f) {
        return this.profileFactory.apply(this, f);
    }

    private FilterProfile defaultCreateProfile(ProfileService srv, FileObject f) {
        return new FilterProfileAdapter(f, srv, this);
    }

    @Override
    public Lookup getLookup() {
        return this.myLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterProfile getSelectedProfile() {
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            return this.selectedProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedProfile(FilterProfile selectedProfile) {
        FilterProfile old;
        FileObject storage = this.getProfileFolder(selectedProfile);
        if (storage == null || storage != this.defaultProfileFolder && storage.getParent() != this.profilesRoot) {
            throw new IllegalArgumentException("Invalid profile");
        }
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            old = this.selectedProfile;
            this.selectedProfile = selectedProfile;
        }
        this.prop.firePropertyChange("selectedProfile", old, selectedProfile);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.prop.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.prop.removePropertyChangeListener(listener);
    }

    @Override
    public FilterProfile getDefaultProfile() {
        return this.defaultProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject getProfileFolder(FilterProfile p) {
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            if (p == this.getDefaultProfile()) {
                return this.defaultProfileFolder;
            }
            for (E e : this.profiles.values()) {
                if (p != e.profile) continue;
                return e.file;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilterProfile> getProfiles() {
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            if (this.profileList == null) {
                if (this.delayedRefresh != null) {
                    this.delayedRefresh.cancel();
                }
            } else {
                return new ArrayList<FilterProfile>(this.profileList);
            }
        }
        return this.refreshProfiles();
    }

    private E createEntry(FileObject nf) {
        this.wasChanged = true;
        return new E(nf, this.profileFactory.apply(this, nf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FilterProfile> refreshProfiles() {
        boolean changed;
        ArrayList<FilterProfile> adapters = new ArrayList<FilterProfile>();
        adapters.add(this.defaultProfile);
        List childList = FileUtil.getOrder(Arrays.asList(this.profilesRoot.getChildren()), (boolean)false);
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            this.delayedRefresh = null;
            this.wasChanged = false;
            for (FileObject fo : childList) {
                if (!fo.isFolder()) continue;
                E e = this.profiles.computeIfAbsent(fo, this::createEntry);
                adapters.add(e.profile);
            }
            HashSet<FileObject> fos = new HashSet<FileObject>(this.profiles.keySet());
            fos.removeAll(childList);
            for (FileObject of : fos) {
                E e = this.profiles.get(of);
                if (e == null) continue;
                e.clear();
            }
            this.profiles.keySet().removeAll(fos);
            this.profileList = adapters;
            changed = this.wasChanged || !fos.isEmpty();
        }
        if (changed) {
            this.prop.firePropertyChange("profiles", null, null);
        }
        return new ArrayList<FilterProfile>(adapters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterProfile createProfile(final String name, final FilterProfile basedOn) throws IOException {
        final AtomicReference aFolder = new AtomicReference();
        this.profilesRoot.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject folder = FilterProfileServiceImpl.this.profilesRoot.createFolder(name);
                aFolder.set(folder);
                folder.getFileSystem().runAtomicAction(() -> {
                    DataFolder target = DataFolder.findFolder((FileObject)folder);
                    ArrayList<FileObject> order = new ArrayList<FileObject>();
                    List<Object> l = basedOn == null ? Collections.emptyList() : basedOn.getProfileFilters();
                    for (Filter filter : l) {
                        FileObject c;
                        FileObject orig = c = (FileObject)filter.getLookup().lookup(FileObject.class);
                        try {
                            FileObject tf = DataShadow.findOriginal((FileObject)c);
                            if (tf != null && tf != c) {
                                orig = tf;
                            }
                        }
                        catch (IOException tf) {
                            // empty catch block
                        }
                        if (c == null) continue;
                        FileObject shf = DataShadow.create((DataFolder)target, (String)c.getName(), (DataObject)DataObject.find((FileObject)orig)).getPrimaryFile();
                        FileUtil.copyAttributes((FileObject)c, (FileObject)shf);
                        order.add(shf);
                    }
                    FileUtil.setOrder(order);
                });
            }
        });
        this.refreshProfiles();
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            return this.profiles.get(aFolder.get()).profile;
        }
    }

    private void scheduleRefresh() {
        if (this.delayedRefresh != null) {
            this.delayedRefresh.cancel();
        }
        this.delayedRefresh = FilterProfileAdapter.REFRESH_RP.post(this::refreshProfiles, 100);
    }

    @Override
    public FileObject getFilterStorage(Filter f) {
        return (FileObject)f.getLookup().lookup(FileObject.class);
    }

    @Override
    public void deleteFilter(Filter f) throws IOException {
        FileObject ff = (FileObject)f.getLookup().lookup(FileObject.class);
        if (ff == null) {
            throw new IOException(Bundle.PROFILE_CannotDeleteFilter(f.getName()));
        }
        FileObject fp = ff.getParent();
        Set<FilterProfile> owners = this.findLocations(f);
        Iterator<FilterProfile> ito = owners.iterator();
        while (ito.hasNext()) {
            FilterProfile p = ito.next();
            if (fp != this.getProfileFolder(p)) continue;
            ito.remove();
        }
        if (!owners.isEmpty()) {
            String s = owners.size() == 1 ? Bundle.PROFILE_FilterIsUsed(owners.iterator().next().getName()) : Bundle.PROFILE_FilterIsUsed2(owners.iterator().next().getName(), owners.size());
            throw new IOException(s);
        }
        ff.delete();
    }

    public FileObject getDefaultProfileFolder() {
        return this.defaultProfileFolder;
    }

    @Override
    public FileObject getProfilesRoot() {
        return this.profilesRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter findDefaultFilter(Filter fromProfile) {
        FileObject storage = this.getFilterStorage(fromProfile);
        try {
            if (storage.getParent() == this.defaultProfileFolder) {
                return fromProfile;
            }
            FileObject linkTarget = DataShadow.findOriginal((FileObject)storage);
            if (linkTarget != null && linkTarget.getParent() == this.defaultProfileFolder) {
                FilterProfileServiceImpl filterProfileServiceImpl = this;
                synchronized (filterProfileServiceImpl) {
                    return this.file2Filter.get(linkTarget);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private FileObject findStorage(Filter f) {
        FileObject fstorage = (FileObject)f.getLookup().lookup(FileObject.class);
        if (fstorage == null) {
            return null;
        }
        FileObject p = fstorage.getParent();
        if (p == this.defaultProfileFolder || p == this.profilesRoot) {
            return fstorage;
        }
        return null;
    }

    private Stream<FilterProfile> findProfiles(FileObject fstorage) {
        if (fstorage == null) {
            return Stream.empty();
        }
        ArrayList<FilterProfile> profs = new ArrayList<FilterProfile>(this.getProfiles());
        return profs.stream().filter(p -> this.findLinkedFilter(fstorage, (FilterProfile)p) != null);
    }

    private FileObject findLinkedFilter(FileObject fstorage, FilterProfile p) {
        FileObject profStorage = this.getProfileFolder(p);
        for (FileObject c : profStorage.getChildren()) {
            try {
                if (fstorage != DataShadow.findOriginal((FileObject)c)) continue;
                return c;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void deleteFromAllProfiles(Filter f) throws IOException {
        try {
            FileObject fstorage = this.findStorage(f);
            this.findProfiles(fstorage).forEach(fpa -> {
                FileObject toDelete = this.findLinkedFilter(fstorage, (FilterProfile)fpa);
                if (toDelete != null) {
                    try {
                        toDelete.delete();
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            });
            fstorage.delete();
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    @Override
    public Set<FilterProfile> findLocations(Filter f) {
        FileObject fstorage = this.findStorage(f);
        return this.findProfiles(fstorage).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProfile(FilterProfile p) throws IOException {
        boolean change;
        final FileObject pd = this.getProfileFolder(p);
        if (pd == null || pd == this.defaultProfileFolder) {
            return;
        }
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            change = p == this.selectedProfile;
        }
        pd.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                pd.delete();
                if (change) {
                    FilterProfileServiceImpl.this.setSelectedProfile(FilterProfileServiceImpl.this.getDefaultProfile());
                }
            }
        });
    }

    private Filter provideIfAbsent(Map<FileObject, Filter> map, FileObject storage, Filter instance) {
        Filter tmp = map.putIfAbsent(storage, instance);
        return tmp == null ? instance : tmp;
    }

    synchronized Filter forFileObject(FileObject f) {
        return this.file2Filter.get(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(FileObject f) {
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            this.file2Filter.remove(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter createFilter(FileObject storage, FilterProfile parent) {
        Filter filter;
        if (!storage.isData()) {
            return null;
        }
        if (storage.getExt().equals("selector")) {
            return null;
        }
        FileObject fo = storage;
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            filter = this.file2Filter.get(storage);
            if (filter != null) {
                return filter;
            }
        }
        FilterProvider chSrc = Filters.locateChainSource((Lookup)fo.getLookup());
        if (chSrc != null) {
            filter = new FilterBridge(fo, parent, chSrc, this);
        } else {
            String code = "";
            try {
                code = fo.asText();
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            CustomFilter cf = new CustomFilter(FilterBridge.file2Name(fo), code, fo.getMIMEType(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this}), fo.getLookup()}));
            LegacyFilterSynchronizer listener = new LegacyFilterSynchronizer(fo, cf){

                public void fileDeleted(FileEvent fe) {
                    FilterProfileServiceImpl.this.removeFromCache(fe.getFile());
                }
            };
            cf.getChangedEvent().addListener((Object)listener);
            fo.addFileChangeListener((FileChangeListener)listener);
            filter = cf;
        }
        FilterProfileServiceImpl filterProfileServiceImpl2 = this;
        synchronized (filterProfileServiceImpl2) {
            Filter existing = this.provideIfAbsent(this.file2Filter, fo, filter);
            return existing;
        }
    }

    @Override
    public void renameFilter(Filter f, String newName) throws IOException {
        FileObject storage = this.getFilterStorage(f);
        if (storage.getParent() == this.defaultProfileFolder) {
            storage.setAttribute("displayName", (Object)newName);
            return;
        }
        if (!FileUtil.isParentOf((FileObject)this.profilesRoot, (FileObject)storage)) {
            return;
        }
        try (FileLock fl = storage.lock();){
            storage.rename(fl, newName, storage.getExt());
        }
    }

    @Override
    public void renameProfile(FilterProfile profile, String newName) throws IOException {
        FileObject storage = this.getProfileFolder(profile);
        if (storage == null) {
            return;
        }
        try (FileLock lck = storage.lock();){
            storage.rename(lck, newName, storage.getExt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterProfile getProfile(FileObject folder) {
        if (folder == this.defaultProfileFolder) {
            return this.defaultProfile;
        }
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            E e = this.profiles.get(folder);
            if (e != null) {
                return e.profile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter getFilter(FileObject filter) {
        FilterProfileServiceImpl filterProfileServiceImpl = this;
        synchronized (filterProfileServiceImpl) {
            return this.file2Filter.get(filter);
        }
    }

    public ProfileStorage getStorage() {
        return this;
    }

    private class FolderListener
    extends FileChangeAdapter {
        private FolderListener() {
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().isFolder()) {
                FilterProfileServiceImpl.this.scheduleRefresh();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            FilterProfileServiceImpl.this.scheduleRefresh();
        }
    }

    final class E
    extends FileChangeAdapter {
        final FileObject file;
        final FilterProfile profile;
        final FileChangeListener wL;

        public E(FileObject file, FilterProfile profile) {
            this.file = file;
            this.profile = profile;
            this.wL = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)file);
            file.addFileChangeListener(this.wL);
        }

        void clear() {
            this.file.removeFileChangeListener(this.wL);
        }

        public void fileDeleted(FileEvent fe) {
            FilterProfileServiceImpl.this.scheduleRefresh();
        }
    }
}

