/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.api;

import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.api.TimelineModel;

public final class TimelineEvent
extends EventObject {
    private final RangeSliderModel originRange;
    private final String partitionType;
    private final int oldPos1;
    private final int oldPos2;
    private final PropertyChangeEvent propEvent;

    public TimelineEvent(TimelineModel source) {
        this(source, null, null, null);
    }

    public TimelineEvent(TimelineModel source, RangeSliderModel sl, String pt, PropertyChangeEvent event) {
        super(source);
        assert (sl == null || pt != null && source.getPartitionRange(pt) == sl);
        this.originRange = sl;
        this.partitionType = pt;
        this.oldPos1 = -1;
        this.oldPos2 = -1;
        this.propEvent = event;
    }

    public TimelineEvent(TimelineModel source, RangeSliderModel sl, String type, int p1, int p2) {
        super(source);
        this.partitionType = type;
        this.originRange = sl;
        this.oldPos1 = p1;
        this.oldPos2 = p2;
        this.propEvent = null;
    }

    public PropertyChangeEvent getPropertyEvent() {
        return this.propEvent;
    }

    public RangeSliderModel getSlider() {
        return this.originRange;
    }

    @Override
    public TimelineModel getSource() {
        return (TimelineModel)this.source;
    }

    public RangeSliderModel getOriginRange() {
        return this.originRange;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public int getFirstGraph() {
        return this.oldPos1;
    }

    public int getSecondGraph() {
        return this.oldPos2;
    }
}

