/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi.execute;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;

public interface JavaRuntimeManager {
    public static final String DEFAULT_RUNTIME_ID = "default_platform";

    public Map<String, JavaRuntime> getAvailableRuntimes();

    default public Optional<Runnable> manageRuntimesAction() {
        return Optional.empty();
    }

    default public void addChangeListener(ChangeListener l) {
    }

    default public void removeChangeListener(ChangeListener l) {
    }

    public static JavaRuntime createJavaRuntime(@NonNull String id, File javaHome) {
        return new JavaRuntime(id, null, javaHome);
    }

    public static JavaRuntime createJavaRuntime(@NonNull String id, String displayName, File javaHome) {
        return new JavaRuntime(id, displayName, javaHome);
    }

    public static final class JavaRuntime
    implements Comparable<JavaRuntime> {
        final String id;
        final String displayName;
        final File javaHome;

        private JavaRuntime(@NonNull String id, String displayName, File javaHome) {
            this.id = id;
            this.displayName = displayName != null ? displayName : id;
            this.javaHome = javaHome;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public File getJavaHome() {
            return this.javaHome;
        }

        public boolean isBroken() {
            return this.javaHome == null || !this.javaHome.isDirectory();
        }

        @Override
        public int compareTo(JavaRuntime o) {
            return this.getDisplayName().compareToIgnoreCase(o.getDisplayName());
        }

        public String toString() {
            return this.getDisplayName();
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaRuntime other = (JavaRuntime)obj;
            return Objects.equals(this.id, other.id);
        }
    }
}

