/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.script;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ScriptEnvironment
implements AutoCloseable {
    public abstract <T> T setValue(Object var1, T var2);

    public final <T, X extends Throwable> T createValue(Object key, ValueSupplier<T, X> s) throws X {
        T t = this.getValue(key);
        if (t == null) {
            t = s.get();
            this.setValue(key, t);
        }
        return t;
    }

    public abstract <T> T getValue(Object var1);

    public abstract Set keys();

    public static final ScriptEnvironment simple() {
        return new ScriptEnvironment(){
            private final Map values = new HashMap();

            @Override
            public <T> T setValue(Object key, T val) {
                return this.values.put(key, val);
            }

            @Override
            public <T> T getValue(Object key) {
                return (T)this.values.get(key);
            }

            @Override
            public Iterable values() {
                return this.values.values();
            }

            @Override
            public Set keys() {
                return new HashSet(this.values.keySet());
            }
        };
    }

    public abstract Iterable values();

    @Override
    public void close() throws IOException {
        for (Object v : this.values()) {
            if (!(v instanceof Closeable)) continue;
            ((Closeable)v).close();
        }
    }

    public static interface ValueSupplier<T, X extends Throwable> {
        public T get() throws X;
    }
}

