/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import org.openide.util.Lookup;
import org.openide.windows.ExternalDropHandler;

public class ExternalDropTarget {
    public static DropTarget createDropTarget(JComponent comp) {
        return new DropTarget(comp, new ExternalDT());
    }

    static class ExternalDT
    implements DropTargetListener {
        ExternalDT() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            for (ExternalDropHandler handler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                if (!handler.canDrop(dtde)) continue;
                dtde.acceptDrag(1);
                return;
            }
            dtde.rejectDrag();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            boolean dropRes = false;
            try {
                for (ExternalDropHandler handler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                    if (!handler.canDrop(dtde)) continue;
                    dtde.acceptDrop(1);
                    dropRes = handler.handleDrop(dtde);
                    break;
                }
            }
            finally {
                dtde.dropComplete(dropRes);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

