/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualizer.util.Bundle;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class GraphTypes {
    private final AbstractNode rootNode;
    private final Map<String, Node> typeNodes = new HashMap<String, Node>();
    private final FileObject registrationRoot;
    private final AbstractNode unknownNode = new AbstractNode(Children.LEAF);
    private List<String> types = null;

    public GraphTypes() {
        this.registrationRoot = FileUtil.getConfigFile((String)"IGV/GraphTypes");
        this.rootNode = new AbstractNode((Children)new Ch());
        this.unknownNode.setIconBaseWithExtension("org/graalvm/visualizer/util/resources/graph_default.png");
        this.unknownNode.setName("<default>");
        this.unknownNode.setDisplayName(Bundle.DefaultGraphType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getOrderedTypes() {
        List<String> tt = this.types;
        if (tt != null) {
            return tt;
        }
        GraphTypes graphTypes = this;
        synchronized (graphTypes) {
            if (this.types == null) {
                this.refreshTypes();
            }
            return this.types;
        }
    }

    public Comparator<String> typeOrderComparator() {
        return new Comparator<String>(){
            private List<String> typeOrder;
            {
                this.typeOrder = GraphTypes.this.getOrderedTypes();
            }

            @Override
            public int compare(String o1, String o2) {
                int b;
                int a = this.typeOrder.indexOf(o1);
                if (a == (b = this.typeOrder.indexOf(o2))) {
                    if (a == -1) {
                        return o1.compareToIgnoreCase(o2);
                    }
                    return 0;
                }
                if (b == -1) {
                    b = Integer.MAX_VALUE;
                }
                return a - b;
            }
        };
    }

    public Node getCategoryNode() {
        return this.rootNode;
    }

    public synchronized Node getTypeNode(String type) {
        Node n = this.typeNodes.get(type);
        if (n != null) {
            return n;
        }
        FileObject t = this.registrationRoot.getFileObject(type);
        if (t == null) {
            return this.unknownNode;
        }
        n = this.createTypeNode(t);
        this.typeNodes.put(type, n);
        return n;
    }

    private synchronized Node createTypeNode(FileObject t) {
        String dispName;
        String type = t.getName();
        Node n = this.typeNodes.get(type);
        if (n != null) {
            return n;
        }
        try {
            dispName = t.getFileSystem().getDecorator().annotateName(type, Collections.singleton(t));
        }
        catch (FileStateInvalidException ex) {
            dispName = type;
        }
        TypeNode an = new TypeNode(t, Children.LEAF);
        an.setName(type);
        an.setDisplayName(dispName);
        this.typeNodes.put(type, (Node)an);
        return an;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileObject[] refreshTypes() {
        FileObject[] contents = this.registrationRoot.getChildren();
        ArrayList<String> types = new ArrayList<String>(contents.length);
        for (FileObject fo : contents) {
            types.add(fo.getName());
        }
        GraphTypes graphTypes = this;
        synchronized (graphTypes) {
            this.types = Collections.unmodifiableList(types);
        }
        return contents;
    }

    private final class Ch
    extends Children.Keys<FileObject>
    implements FileChangeListener {
        public Ch() {
            GraphTypes.this.registrationRoot.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)GraphTypes.this.registrationRoot));
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshFiles();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.refreshFiles();
        }

        public void fileDeleted(FileEvent fe) {
            this.refreshFiles();
        }

        public void fileRenamed(FileRenameEvent fre) {
            this.refreshFiles();
        }

        public void fileAttributeChanged(FileAttributeEvent fae) {
            this.refreshFiles();
        }

        void refreshFiles() {
            this.setKeys(GraphTypes.this.refreshTypes());
        }

        protected Node[] createNodes(FileObject t) {
            Node[] nodeArray;
            Node n = GraphTypes.this.createTypeNode(t);
            if (n == null) {
                nodeArray = null;
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            }
            return nodeArray;
        }
    }

    private static class TypeNode
    extends AbstractNode {
        private final FileObject typeFile;

        public TypeNode(FileObject typeFile, Children children) {
            super(children);
            this.typeFile = typeFile;
        }

        public Image getOpenedIcon(int type) {
            try {
                return FileUIUtils.getImageDecorator((FileSystem)this.typeFile.getFileSystem()).annotateIcon(null, type, Collections.singleton(this.typeFile));
            }
            catch (FileStateInvalidException ex) {
                return super.getOpenedIcon(type);
            }
        }

        public Image getIcon(int type) {
            try {
                return FileUIUtils.getImageDecorator((FileSystem)this.typeFile.getFileSystem()).annotateIcon(null, type, Collections.singleton(this.typeFile));
            }
            catch (FileStateInvalidException ex) {
                return super.getIcon(type);
            }
        }
    }
}

