/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class LookupHistory {
    private static final Map<Class<?>, LookupHistoryImpl> cache = new HashMap();

    public static <T> void init(Class<T> klass) {
        if (!cache.containsKey(klass)) {
            cache.put(klass, new LookupHistoryImpl<T>(klass));
        }
    }

    public static <T> T getLast(Class<T> klass) {
        LookupHistory.init(klass);
        assert (cache.containsKey(klass));
        return cache.get(klass).getLast();
    }

    private static class LookupHistoryImpl<T>
    implements LookupListener {
        private final Class<T> klass;
        private final Lookup.Result<T> result;
        private Reference<T> last;

        public LookupHistoryImpl(Class<T> klass) {
            this.klass = klass;
            this.result = Utilities.actionsGlobalContext().lookupResult(klass);
            this.result.addLookupListener((LookupListener)this);
            this.last = new WeakReference<Object>(Utilities.actionsGlobalContext().lookup(klass));
        }

        public T getLast() {
            return this.last.get();
        }

        public void resultChanged(LookupEvent ev) {
            Object current = Utilities.actionsGlobalContext().lookup(this.klass);
            if (current != null) {
                this.last = new WeakReference<Object>(current);
            }
        }
    }
}

