/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.util.Bundle;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;

public class PropertiesSheet {
    public static void initializeSheet(Properties properties, Sheet s) {
        Sheet.Set set1 = Sheet.createPropertiesSet();
        PropertiesSheet.populateSheetSet(set1, properties);
        s.put(set1);
    }

    private static void populateSheetSet(Sheet.Set set1, Properties properties) {
        set1.setDisplayName(Bundle.CAT_Properties());
        properties.forEach(p -> {
            if (!p.getName().startsWith("!")) {
                set1.put(PropertiesSheet.createSheetProperty(p.getName(), properties));
            }
        });
    }

    public static Node.Property createSheetProperty(String n, Properties properties) {
        return PropertiesSheet.createSheetProperty(n, null, properties);
    }

    public static Node.Property createSheetProperty(final String n, String dispName, final Properties properties) {
        Object prop;
        Class<Object> c;
        final Object v = properties.get(n);
        if (v != null && (c = v.getClass()).isArray()) {
            prop = c.getComponentType().isPrimitive() ? new IndexedPrimitive(c, properties, n) : new IndexedObjectProperty(properties, n);
        } else if (v instanceof List && !((List)v).isEmpty()) {
            prop = new IndexedListProperty(properties, n, ((List)v).get(0).getClass());
        } else {
            c = Object.class;
            if (v != null) {
                c = v.getClass();
            }
            prop = new Node.Property<Object>(c){

                public boolean canRead() {
                    return true;
                }

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return properties.get(n);
                }

                public boolean canWrite() {
                    return false;
                }

                public void setValue(Object arg0) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    throw new UnsupportedOperationException(Bundle.ERR_PropertyReadOnly());
                }

                public PropertyEditor getPropertyEditor() {
                    Object pe = super.getPropertyEditor();
                    if (pe == null || v == null) {
                        pe = new StringDelegatePropertyEditor();
                    }
                    return pe;
                }
            };
        }
        prop.setName(dispName == null ? n : dispName);
        return prop;
    }

    private static class IndexedPrimitive
    extends Node.IndexedProperty<Object, String> {
        private final Properties props;
        private final String name;

        public IndexedPrimitive(Class c, Properties props, String name) {
            super(c, String.class);
            this.props = props;
            this.name = name;
        }

        public boolean canIndexedRead() {
            return true;
        }

        public String getIndexedValue(int i) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object o = this.props.get(this.name);
            if (o == null) {
                return null;
            }
            int l = Array.getLength(o);
            if (i >= l) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            return Objects.toString(Array.get(o, i));
        }

        public boolean canIndexedWrite() {
            return false;
        }

        public void setIndexedValue(int i, String e) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException(Bundle.ERR_PropertyReadOnly());
        }

        public boolean canRead() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.props.get(this.name);
        }

        public boolean canWrite() {
            return false;
        }

        public void setValue(Object t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException(Bundle.ERR_PropertyReadOnly());
        }
    }

    private static class IndexedObjectProperty
    extends Node.IndexedProperty<Object[], String> {
        private final Properties props;
        private final String name;

        public IndexedObjectProperty(Properties props, String name) {
            super(Object[].class, String.class);
            this.props = props;
            this.name = name;
        }

        public boolean canIndexedRead() {
            return true;
        }

        public String getIndexedValue(int i) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Object[] o = (Object[])this.props.get(this.name, Object[].class);
            if (o == null) {
                return null;
            }
            int l = Array.getLength(o);
            if (i >= l) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            return Objects.toString(o[i]);
        }

        public boolean canIndexedWrite() {
            return false;
        }

        public void setIndexedValue(int i, String e) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException(Bundle.ERR_PropertyReadOnly());
        }

        public boolean canRead() {
            return true;
        }

        public Object[] getValue() throws IllegalAccessException, InvocationTargetException {
            return (Object[])this.props.get(this.name, Object[].class);
        }

        public boolean canWrite() {
            return false;
        }

        public void setValue(Object[] t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException(Bundle.ERR_PropertyReadOnly());
        }
    }

    static final class IndexedListProperty
    extends Node.IndexedProperty<Object[], Object> {
        private final Properties props;
        private final String name;

        public IndexedListProperty(Properties props, String name, Class itemType) {
            super(Object[].class, itemType);
            this.props = props;
            this.name = name;
        }

        public boolean canIndexedRead() {
            return true;
        }

        private List l() {
            return (List)this.props.get(this.name, List.class);
        }

        public Object getIndexedValue(int i) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.l().get(i);
        }

        public boolean canIndexedWrite() {
            return false;
        }

        public void setIndexedValue(int i, Object e) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean canRead() {
            return true;
        }

        public Object[] getValue() throws IllegalAccessException, InvocationTargetException {
            return this.l().toArray();
        }

        public boolean canWrite() {
            return false;
        }

        public void setValue(Object[] t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class StringDelegatePropertyEditor
    implements ExPropertyEditor {
        private final PropertyEditor delegate = PropertyEditorManager.findEditor(String.class);

        public void setValue(Object value) {
            this.delegate.setValue(Objects.toString(value));
        }

        public Object getValue() {
            return this.delegate.getValue();
        }

        public boolean isPaintable() {
            return this.delegate.isPaintable();
        }

        public void paintValue(Graphics gfx, Rectangle box) {
            this.delegate.paintValue(gfx, box);
        }

        public String getJavaInitializationString() {
            return this.delegate.getJavaInitializationString();
        }

        public String getAsText() {
            return this.delegate.getAsText();
        }

        public void setAsText(String text) throws IllegalArgumentException {
            this.delegate.setAsText(text);
        }

        public String[] getTags() {
            return this.delegate.getTags();
        }

        public Component getCustomEditor() {
            return this.delegate.getCustomEditor();
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(listener);
        }

        public void attachEnv(PropertyEnv pe) {
            if (this.delegate instanceof ExPropertyEditor) {
                ((ExPropertyEditor)this.delegate).attachEnv(pe);
            }
        }
    }
}

