/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;

public class RangeSliderModel
implements ChangedEventProvider<RangeSliderModel> {
    public static final String PROP_POSITIONS = "positions";
    public static final String PROP_GAPS = "gaps";
    protected static final Color DEFAULT_COLOR = Color.BLACK;
    private final ChangedEvent<RangeSliderModel> changedEvent;
    private final ChangedEvent<RangeSliderModel> colorChangedEvent;
    private List<String> positions;
    private int firstPosition;
    private int secondPosition;
    private List<Color> colors;
    private List<Color> hatches;
    public static final String FIRST_POSITION = new String("first-position");
    private Map<String, Integer> slots = null;
    private List<String> spacedPositions;
    private int[] indices;
    private int slotCount = -1;
    protected final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);

    private RangeSliderModel() {
        this.changedEvent = new ChangedEvent((Object)this);
        this.colorChangedEvent = new ChangedEvent((Object)this);
    }

    protected RangeSliderModel(List<String> positions) {
        this();
        assert (positions.size() > 0);
        this.setPositionsInternal(positions);
    }

    protected RangeSliderModel(RangeSliderModel model) {
        this();
        this.setDataInternal(model);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(RangeSliderModel model) {
        boolean colorChanged;
        boolean changed;
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            changed = this.getPositionsDiffers(model);
            colorChanged = this.getColorsDiffers(model);
            this.setDataInternal(model);
        }
        if (changed) {
            this.changedEvent.fire();
        }
        if (colorChanged) {
            this.colorChangedEvent.fire();
        }
    }

    protected final synchronized boolean getPositionsDiffers(RangeSliderModel model) {
        return this.getPositionsDiffers(model.firstPosition, model.secondPosition) || !this.positions.equals(model.positions);
    }

    private boolean getPositionsDiffers(int firstPosition, int secondPosition) {
        return firstPosition != this.firstPosition || secondPosition != this.secondPosition;
    }

    protected final synchronized boolean getColorsDiffers(RangeSliderModel model) {
        return !this.colors.equals(model.colors);
    }

    private void invalidate() {
        this.slotCount = -1;
        this.indices = null;
    }

    private void updateIndices() {
        if (this.slotCount >= 0) {
            return;
        }
        if (this.positions.isEmpty()) {
            this.slotCount = 0;
            this.indices = null;
            return;
        }
        this.spacedPositions = null;
        int[] ni = new int[this.positions.size()];
        int i = 0;
        int c = 0;
        boolean missing = false;
        Map<String, Integer> sl = this.slots;
        if (sl == null) {
            for (int p = ni.length - 1; p >= 0; --p) {
                ni[p] = p;
            }
            c = ni.length;
        } else {
            for (String s : this.positions) {
                Integer x = sl.get(s);
                if (x == null) {
                    ni[i] = -1;
                    missing = true;
                } else {
                    ni[i] = x;
                    if (c <= x) {
                        c = x + 1;
                    }
                }
                ++i;
            }
        }
        if (missing) {
            int x = -1;
            int delta = 0;
            for (int n = 0; n < ni.length; ++n) {
                if (ni[n] == -1) {
                    ni[n] = x;
                    ++delta;
                } else {
                    if (delta > 0) {
                        int n2 = n;
                        ni[n2] = ni[n2] + delta;
                    }
                    x = ni[n];
                }
                ++x;
            }
            c += delta;
        }
        this.slotCount = c;
        this.indices = (int[])(c == this.positions.size() ? null : ni);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setIndices(Map<String, Integer> indices) {
        if (Objects.equals(this.slots, indices)) {
            return;
        }
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            this.slots = indices;
            this.invalidate();
        }
        this.changedEvent.fire();
    }

    protected final synchronized void setDataInternal(RangeSliderModel model) {
        this.positions = model.positions;
        this.firstPosition = model.firstPosition;
        this.secondPosition = model.secondPosition;
        this.colors = model.colors;
        this.slots = model.slots;
        this.hatches = model.hatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setPositionsInternal(List<String> positions) {
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            this.positions = positions;
            this.invalidate();
        }
        this.resetColors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPositions(List<String> positions) {
        List<String> oldPos;
        assert (positions.size() > 0);
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            if (this.positions.equals(positions)) {
                return;
            }
            oldPos = this.positions;
            this.setPositionsInternal(positions);
            this.remapPositions(oldPos);
        }
        this.colorChangedEvent.fire();
        this.propSupport.firePropertyChange(PROP_POSITIONS, oldPos, positions);
    }

    private boolean remapPositions(List<String> prevPos) {
        boolean r;
        int s;
        int p1 = this.getFirstPosition();
        int p2 = this.getSecondPosition();
        int f = this.findMatchingPosition(prevPos, p1);
        if (f > (s = this.findMatchingPosition(prevPos, p2))) {
            int a = s;
            s = f;
            f = a;
        }
        boolean bl = r = f != p1 || s != p2;
        if (r) {
            this.setPositions(f, s);
        } else {
            this.changedEvent.fire();
        }
        return r;
    }

    int findMatchingPosition(List<String> prev, int index) {
        if (index < 0) {
            return 0;
        }
        if (index >= prev.size()) {
            if (index >= this.positions.size()) {
                return 0;
            }
            return index;
        }
        String s = prev.get(index);
        int n = this.positions.indexOf(s);
        while (n == -1 && index > 0) {
            s = prev.get(--index);
            n = this.positions.indexOf(s);
        }
        if (n >= 0) {
            return n;
        }
        if (index < this.positions.size()) {
            return index;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int gapSizeBefore(String name) {
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            int posIndex = this.positions.indexOf(name);
            if (posIndex == -1) {
                return 0;
            }
            this.updateIndices();
            int ind1 = this.indices[posIndex];
            if (posIndex == 0) {
                return ind1;
            }
            int ind0 = this.indices[posIndex - 1];
            return ind1 - ind0 - 1;
        }
    }

    private void resetColors() {
        this.colors = new ArrayList<Color>(Collections.nCopies(this.positions.size(), DEFAULT_COLOR));
        this.hatches = Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColors(List<Color> colors) {
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            if (this.colors.equals(colors)) {
                return;
            }
            this.colors = new ArrayList<Color>(colors);
            this.hatches = Collections.emptyList();
        }
        this.colorChangedEvent.fire();
    }

    public synchronized void setHatchColors(List<Color> colors) {
        if (this.hatches.equals(colors)) {
            return;
        }
        this.hatches = new ArrayList<Color>(colors);
        this.colorChangedEvent.fire();
    }

    public synchronized List<Color> getHatchColors() {
        return Collections.unmodifiableList(this.hatches);
    }

    public synchronized List<Color> getColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public synchronized RangeSliderModel copy() {
        return new RangeSliderModel(this);
    }

    public synchronized List<String> getPositions() {
        return Collections.unmodifiableList(this.positions);
    }

    public synchronized int findPosition(int slot) {
        if (this.slots == null) {
            return slot;
        }
        for (Map.Entry<String, Integer> s : this.slots.entrySet()) {
            if (s.getValue() != slot) continue;
            return this.positions.indexOf(s.getKey());
        }
        return -1;
    }

    public synchronized int getSlot(int position) {
        if (this.slots == null) {
            return position;
        }
        if (position >= this.positions.size()) {
            return position - this.positions.size() + this.slotCount;
        }
        String n = this.positions.get(position);
        Integer ind = this.slots.get(n);
        return ind == null ? position : ind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPositions(boolean withSpaces) {
        ArrayList<String> res;
        if (!withSpaces) {
            return this.getPositions();
        }
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            if (this.positions.isEmpty()) {
                return this.getPositions();
            }
            if (this.spacedPositions != null) {
                return this.spacedPositions;
            }
            this.updateIndices();
            ArrayList<String> arr = new ArrayList<String>(this.positions);
            res = new ArrayList<String>(this.slotCount);
            if (this.indices == null) {
                res.addAll(arr);
            } else {
                for (int i = arr.size() - 1; i >= 0; --i) {
                    String n = (String)arr.get(i);
                    int pos = this.indices[i];
                    if (pos >= res.size()) {
                        while (pos > res.size()) {
                            res.add(null);
                        }
                        res.add(n);
                        continue;
                    }
                    res.set(pos, n);
                }
            }
            this.spacedPositions = res;
        }
        return res;
    }

    public synchronized int getPositionCount(boolean includingGaps) {
        this.updateIndices();
        return includingGaps ? this.slotCount : this.positions.size();
    }

    public synchronized int getFirstPosition() {
        return this.firstPosition;
    }

    public synchronized int getSecondPosition() {
        return this.secondPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPositions(int fp, int sp) {
        assert (fp <= sp);
        RangeSliderModel rangeSliderModel = this;
        synchronized (rangeSliderModel) {
            if (!this.getPositionsDiffers(fp, sp)) {
                return;
            }
            this.firstPosition = fp;
            this.secondPosition = sp;
            this.changedEvent.fire();
        }
        this.propSupport.firePropertyChange(PROP_POSITIONS, null, null);
    }

    public ChangedEvent<RangeSliderModel> getColorChangedEvent() {
        return this.colorChangedEvent;
    }

    public ChangedEvent<RangeSliderModel> getChangedEvent() {
        return this.changedEvent;
    }
}

