/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.graalsdk.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.netbeans.libs.graalsdk.impl.WriterOutputStream;
import org.openide.util.io.ReaderInputStream;

final class GraalContext
implements ScriptContext {
    private static final String ALLOW_ALL_ACCESS = "allowAllAccess";
    private Context ctx;
    private final WriterOutputStream writer = new WriterOutputStream(new OutputStreamWriter(System.out));
    private final WriterOutputStream errorWriter = new WriterOutputStream(new OutputStreamWriter(System.err));
    private Reader reader;
    private final Bindings globals;
    private SimpleBindings bindings;
    private boolean allowAllAccess;
    private final ClassLoader languagesClassLoader;
    private static final HostAccess SANDBOX = HostAccess.newBuilder().allowPublicAccess(true).allowArrayAccess(true).allowListAccess(true).allowAllImplementations(true).denyAccess(Class.class).denyAccess(Method.class).denyAccess(Field.class).denyAccess(Proxy.class).denyAccess(Object.class, false).build();

    GraalContext(Bindings globals, ClassLoader langClassLoader) {
        this.globals = globals;
        this.languagesClassLoader = langClassLoader;
    }

    final synchronized Context ctx() {
        if (this.ctx == null) {
            Context.Builder b = Context.newBuilder((String[])new String[0]);
            b.out((OutputStream)this.writer);
            b.err((OutputStream)this.errorWriter);
            if (this.reader != null) {
                try {
                    b.in((InputStream)new ReaderInputStream(this.reader, "UTF-8"));
                }
                catch (IOException ex) {
                    throw GraalContext.raise(RuntimeException.class, ex);
                }
            }
            b.allowPolyglotAccess(PolyglotAccess.ALL);
            if (Boolean.TRUE.equals(this.getAttribute(ALLOW_ALL_ACCESS, 200))) {
                b.allowHostAccess(HostAccess.ALL);
                b.allowAllAccess(true);
            } else {
                b.allowHostAccess(SANDBOX);
            }
            b.hostClassLoader(Thread.currentThread().getContextClassLoader());
            this.ctx = GraalContext.executeWithClassLoader(() -> b.build(), this.languagesClassLoader);
            if (this.globals != null) {
                for (String k : this.globals.keySet()) {
                    if (ALLOW_ALL_ACCESS.equals(k)) continue;
                    this.ctx.getPolyglotBindings().putMember(k, this.globals.get(k));
                }
            }
        }
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T executeWithClassLoader(Supplier<T> code, ClassLoader loader) {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            T t = code.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxLoader);
        }
    }

    Bindings getGlobals() {
        return this.globals;
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings getBindings(int scope) {
        this.assertGlobalScope(scope);
        if (this.bindings == null) {
            Map map = (Map)this.ctx().getPolyglotBindings().as(Map.class);
            this.bindings = new SimpleBindings(map);
        }
        return this.bindings;
    }

    private void assertGlobalScope(int scope) throws IllegalArgumentException {
        if (scope != 200) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.assertGlobalScope(scope);
        if (ALLOW_ALL_ACCESS.equals(name)) {
            if (this.ctx == null) {
                this.allowAllAccess = Boolean.TRUE.equals(value);
                return;
            }
            throw new IllegalStateException();
        }
        if (this.ctx != null) {
            this.getBindings(200).put(name, value);
        } else if (this.globals != null) {
            this.globals.put(name, value);
        }
    }

    @Override
    public Object getAttribute(String name, int scope) {
        this.assertGlobalScope(scope);
        return this.getGlobalAttribute(name);
    }

    private Object getGlobalAttribute(String name) {
        if (ALLOW_ALL_ACCESS.equals(name)) {
            if (this.allowAllAccess) {
                return true;
            }
        } else if (this.ctx != null) {
            return this.getBindings(200).get(name);
        }
        return this.globals == null ? null : this.globals.get(name);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        this.assertGlobalScope(scope);
        if (this.ctx != null) {
            Bindings b = this.getBindings(200);
            return b.remove(name);
        }
        return this.globals == null ? null : this.globals.remove(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.getGlobalAttribute(name);
    }

    @Override
    public int getAttributesScope(String name) {
        if (ALLOW_ALL_ACCESS.equals(name)) {
            return 200;
        }
        if (this.ctx != null && this.getBindings(200).containsKey(name)) {
            return 200;
        }
        if (this.globals != null && this.globals.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer.getWriter();
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter.getWriter();
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer.setWriter(writer);
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter.setWriter(writer);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        if (this.ctx != null) {
            throw new IllegalStateException("Too late. Context has already been created!");
        }
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return Collections.nCopies(1, 200);
    }

    private static <T extends Exception> T raise(Class<T> aClass, Throwable ex) throws T {
        throw (Exception)ex;
    }
}

