/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graalvm.visualizer.source.impl.LanguageRegistryImpl;
import org.openide.util.Lookup;

public final class Language {
    private final String graalID;
    private final String mimeType;
    private final String displayName;
    private final Lookup lookup;
    private static final Registry REGISTRY_INSTANCE = new Registry();
    private static final String HOST_LANGUAGE_GRAALID = "Java";

    public Language(String graalID, String mimeType, String displayName, Lookup lkp) {
        this.graalID = graalID;
        this.mimeType = mimeType;
        this.displayName = displayName;
        this.lookup = lkp == null ? Lookup.EMPTY : lkp;
    }

    public String getGraalID() {
        return this.graalID;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isRunnable() {
        return REGISTRY_INSTANCE.getRunnableLanguages().contains(this);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public boolean isHostLanguage() {
        return HOST_LANGUAGE_GRAALID.equals(this.getGraalID());
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.graalID);
        return hash;
    }

    public static Registry getRegistry() {
        return REGISTRY_INSTANCE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Language other = (Language)obj;
        return Objects.equals(this.graalID, other.graalID);
    }

    public String toString() {
        return this.displayName + "[" + this.mimeType + " : " + this.graalID + "]";
    }

    public static final class Registry {
        private final LanguageRegistryImpl impl = new LanguageRegistryImpl();

        public Language findLanguageByMime(String mimeType) {
            return this.getSupportedLanguages().stream().filter(l -> l.getMimeType().equals(mimeType)).findAny().orElse(null);
        }

        public Language makeLanguage(String graalID) {
            Language lng = this.findLanguageByID(graalID);
            if (lng != null) {
                return lng;
            }
            return this.impl.createLanguage(graalID);
        }

        public Language findLanguageByID(String id) {
            return this.impl.finLanguageId(id);
        }

        public Collection<Language> getSupportedLanguages() {
            return this.impl.getLanguages();
        }

        public Collection<Language> getRunnableLanguages() {
            return this.impl.getRunnableLanguages();
        }

        public Collection<String> getLanguageIDs() {
            return this.getSupportedLanguages().stream().map(l -> l.getGraalID()).collect(Collectors.toList());
        }

        public Collection<String> getMimeTypes() {
            return this.getSupportedLanguages().stream().map(l -> l.getMimeType()).collect(Collectors.toList());
        }
    }
}

