/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.SpecificLocationInfo;
import org.graalvm.visualizer.source.StackData;
import org.graalvm.visualizer.source.spi.LocationResolver;
import org.graalvm.visualizer.source.spi.StackProcessor;
import org.openide.filesystems.FileObject;

public final class ProcessorContext {
    private final GraphSource source;
    private final InputGraph graph;
    private final FileRegistry fileRegistry;
    private final Language language;
    private final String mime;
    private List<LocationResolver> resolvers;
    Map<InputNode, StackData> stacks = new HashMap<InputNode, StackData>();
    Map<Location, Set<Location>> successors = new HashMap<Location, Set<Location>>();
    Map<Location, Collection<StackData>> finalLocations = new HashMap<Location, Collection<StackData>>();
    private Map<Location, Location> locations = new HashMap<Location, Location>();
    Set<FileKey> seenFiles = new HashSet<FileKey>();
    Map<FileKey, Collection<Location>> keyLocations = new HashMap<FileKey, Collection<Location>>();
    Map<FileObject, Collection<Location>> fileLocations = new HashMap<FileObject, Collection<Location>>();
    private List<StackProcessor> processors = new ArrayList<StackProcessor>();

    ProcessorContext(GraphSource source, InputGraph graph, FileRegistry fileRegistry, String langID) {
        this.graph = graph;
        this.fileRegistry = fileRegistry;
        this.mime = langID;
        this.source = source;
        this.language = Language.getRegistry().makeLanguage(langID);
    }

    public String getLangID() {
        return this.language.getGraalID();
    }

    public String getMimeType() {
        return this.mime;
    }

    Map<Location, Set<Location>> succ() {
        return this.successors;
    }

    void addProcessor(StackProcessor processor) {
        this.processors.add(processor);
        processor.attach(this);
    }

    void processNode(InputNode n) {
        for (StackProcessor p : this.processors) {
            List<Location> locs = p.processStack(n);
            if (locs == null) continue;
            this.addNodeStack(locs, n);
            break;
        }
    }

    public InputGraph getGraph() {
        return this.graph;
    }

    public boolean isGraphNested() {
        return !(this.graph.getParent() instanceof Group);
    }

    private Location finishNewLocation(Location l) {
        if (l.isResolved()) {
            this.fileLocations.computeIfAbsent(l.getOriginFile(), x -> new ArrayList()).add(l);
        } else {
            this.keyLocations.computeIfAbsent(l.getFile(), x -> new ArrayList()).add(l);
        }
        return l;
    }

    private Location unique(Location l) {
        return this.locations.computeIfAbsent(l, loc -> {
            Location srcLoc = this.source.uniqueLocation(l);
            return this.finishNewLocation(srcLoc);
        });
    }

    private Collection<StackData> addOrCreateStack(Location s, Collection<StackData> existing) {
        if (existing == null) {
            existing = new HashSet<StackData>();
        }
        return existing;
    }

    private FileObject attemptResolve(Location l) {
        if (l.isResolved() || !this.seenFiles.add(l.getFile())) {
            return l.getOriginFile();
        }
        if (this.resolvers == null) {
            this.resolvers = this.fileRegistry.createResolvers(this.mime, this.getGraph());
        }
        for (LocationResolver r : this.resolvers) {
            FileObject f = r.resolve(l.getFile());
            if (f == null) continue;
            this.fileRegistry.resolve(l.getFile(), f);
            return f;
        }
        return null;
    }

    private void addNodeStack(List<Location> currentStack, InputNode node) {
        int len = currentStack.size();
        if (len == 0) {
            return;
        }
        Location parent = null;
        for (int i = len - 1; i >= 0; --i) {
            Location l = currentStack.get(i);
            if (!l.isResolved()) {
                this.attemptResolve(l);
            }
            l.setParent(parent);
            if (parent != null) {
                this.successors.compute(parent, this::createOrAdd).add(l);
            }
            l = this.unique(l);
            currentStack.set(i, l);
            parent = l;
        }
        StackData stack = new StackData(node.getId(), this.mime, currentStack);
        this.stacks.put(node, stack);
        this.finalLocations.compute(parent, this::addOrCreateStack).add(stack);
    }

    public void attachInfo(Location l, SpecificLocationInfo i) {
        l.attach(i);
    }

    private Set<Location> createOrAdd(Location l, Set<Location> c) {
        if (c == null) {
            c = new HashSet<Location>();
        }
        return c;
    }

    public FileKey file(String filename, FileObject resolved) {
        return this.uniqueKey(resolved == null ? new FileKey(this.mime, filename) : new FileKey(filename, resolved));
    }

    public FileKey uniqueKey(FileKey k) {
        return this.fileRegistry.enter(k, this.getGraph());
    }
}

