/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.List;
import java.util.Objects;
import org.graalvm.visualizer.source.Location;

final class StackData {
    private final int nodeId;
    private final String mimeType;
    private final List<Location> locations;

    StackData(int nodeId, String mimeType, List<Location> locations) {
        this.mimeType = mimeType;
        this.nodeId = nodeId;
        this.locations = locations;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int size() {
        return this.locations.size();
    }

    public String getLanguageMimeType() {
        return this.mimeType;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + this.nodeId;
        hash = 19 * hash + Objects.hashCode(this.mimeType);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackData other = (StackData)obj;
        if (this.nodeId != other.nodeId) {
            return false;
        }
        return Objects.equals(this.mimeType, other.mimeType);
    }

    public List<Location> getLocations() {
        return this.locations;
    }
}

