/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.source.SourcesRoot;
import org.graalvm.visualizer.source.impl.FileRoot;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class FileGroup
implements SourcesRoot,
PathResourceImplementation {
    static final String PROP_DISPLAY_NAME = "displayName";
    private static final List<W> registeredPaths = new ArrayList<W>();
    private final URI uri;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final List<FileRoot> roots = new ArrayList<FileRoot>();
    private final ClassPath cpI;
    private final MutableClassPathImplementation cpImpl;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final SourceRepositoryImpl storage;
    private final Lookup lkp;
    private final W wPathRef;
    private String displayName;
    private List<URL> fileRoots = new ArrayList<URL>();

    public FileGroup(URI uri, String displayName, SourceRepositoryImpl storage) {
        this.uri = uri;
        this.displayName = displayName;
        this.storage = storage;
        this.cpImpl = new MutableClassPathImplementation();
        this.cpI = ClassPathFactory.createClassPath((ClassPathImplementation)this.cpImpl);
        this.lkp = Lookups.fixed((Object[])new Object[]{this.cpI, storage});
        this.wPathRef = new W(this.getSourcePath(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRegisteredPath() {
        List<W> list = registeredPaths;
        synchronized (list) {
            registeredPaths.add(this.wPathRef);
        }
        GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{this.wPathRef.registeredPath});
    }

    void removeRegisteredPath() {
        FileGroup.removeRegisteredPath(this.wPathRef);
        this.wPathRef.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeRegisteredPath(W w) {
        List<W> list = registeredPaths;
        synchronized (list) {
            registeredPaths.remove(w);
        }
        GlobalPathRegistry.getDefault().unregister("classpath/source", new ClassPath[]{w.registeredPath});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileRoot> getFileRoots() {
        List<FileRoot> list = this.roots;
        synchronized (list) {
            return new ArrayList<FileRoot>(this.roots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(URL u) {
        List<FileRoot> list = this.roots;
        synchronized (list) {
            for (FileRoot r : this.roots) {
                if (!r.getLocation().equals(u)) continue;
                return true;
            }
        }
        return false;
    }

    public URL[] getRoots() {
        return this.fileRoots.toArray(new URL[this.fileRoots.size()]);
    }

    public ClassPathImplementation getContent() {
        return this.cpImpl;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.supp.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.supp.removePropertyChangeListener(listener);
    }

    private void refreshURLs() {
        ArrayList<URL> urls = new ArrayList<URL>(this.roots.size());
        for (FileRoot fr : this.roots) {
            urls.add(fr.getLocation());
        }
        this.fileRoots = urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRoot(FileRoot r) {
        List<FileRoot> list = this.roots;
        synchronized (list) {
            this.roots.add(r);
            this.refreshURLs();
        }
        this.cpImpl.addResource(r.getLocation());
        this.supp.firePropertyChange("roots", null, null);
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(FileRoot r) {
        List<FileRoot> list = this.roots;
        synchronized (list) {
            if (!this.roots.remove(r)) {
                return;
            }
            this.refreshURLs();
        }
        this.cpImpl.removeResource(r.getLocation());
        this.supp.firePropertyChange("roots", null, null);
        this.fireChange();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setDisplayName(String displayName) {
        String old = this.displayName;
        if (Objects.equals(old, displayName)) {
            return;
        }
        try {
            this.storage.renameGroup(this, displayName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.displayName = displayName;
        this.supp.firePropertyChange(PROP_DISPLAY_NAME, old, displayName);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ClassPath getSourcePath() {
        return this.cpI;
    }

    @Override
    public Lookup getLookup() {
        return this.lkp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChange() {
        ChangeListener[] ll;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    public String toString() {
        return "Group-" + this.uri + "[" + this.getDisplayName() + "]";
    }

    private static class MutableClassPathImplementation
    implements ClassPathImplementation {
        private final List<PathResourceImplementation> res = new ArrayList<PathResourceImplementation>();
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);

        public void addResource(URL url) {
            this.res.add(ClassPathSupport.createResource((URL)url));
            this.support.firePropertyChange("resources", null, null);
        }

        public void removeResource(URL url) {
            Iterator<PathResourceImplementation> it = this.res.iterator();
            while (it.hasNext()) {
                PathResourceImplementation r = it.next();
                if (!url.equals(r.getRoots()[0])) continue;
                it.remove();
                this.support.firePropertyChange("resources", null, null);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public List<PathResourceImplementation> getResources() {
            return this.res;
        }
    }

    private static class W
    extends WeakReference<FileGroup>
    implements Runnable {
        private final ClassPath registeredPath;

        public W(ClassPath registeredPath, FileGroup referent) {
            super(referent, Utilities.activeReferenceQueue());
            this.registeredPath = registeredPath;
        }

        @Override
        public void run() {
            FileGroup.removeRegisteredPath(this);
        }
    }
}

