/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;

public final class FileRoot {
    private static final String PROP_DISPLAY_NAME = "displayName";
    private final URL rootURL;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final SourceRepositoryImpl storage;
    private String displayName;
    private FileGroup parent;

    FileRoot(SourceRepositoryImpl storage, URL fileURL) {
        this.rootURL = fileURL;
        this.storage = storage;
    }

    public FileGroup getParent() {
        return this.parent;
    }

    void setParent(FileGroup parent) {
        this.parent = parent;
    }

    public URL getLocation() {
        return this.rootURL;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        String old = this.displayName;
        if (Objects.equals(old, displayName)) {
            return;
        }
        this.displayName = displayName;
        if (this.parent != null) {
            this.storage.setRootName(this.rootURL, displayName);
        }
        this.supp.firePropertyChange(PROP_DISPLAY_NAME, old, displayName);
    }

    public void discard() throws IOException {
        this.storage.removeRoot(this);
    }

    public void moveTo(FileGroup otherGroup) throws IOException {
        if (this.getParent() == otherGroup) {
            return;
        }
        this.storage.removeRoot(this);
        this.storage.addFileRoot(this, otherGroup);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.supp.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.supp.removePropertyChangeListener(listener);
    }
}

