/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.source.impl.Bundle;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.FileRoot;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class SourceRepositoryImpl {
    private Preferences prefs;
    private int highestIndex;
    private final Map<URI, String> groupKeys = new HashMap<URI, String>();
    private final Map<URL, String> fileKeys = new HashMap<URL, String>();
    private final Map<URL, FileRoot> fileRoots = new HashMap<URL, FileRoot>();
    private final Map<String, FileGroup> groups = new HashMap<String, FileGroup>();
    private final FileGroup defaultGroup;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static volatile SourceRepositoryImpl INSTANCE;

    SourceRepositoryImpl(Preferences prefs) {
        try {
            this.prefs = prefs;
            prefs.flush();
            this.defaultGroup = new FileGroup(new URI("urn:defaultGroup"), Bundle.NAME_DefaultGroup(), this);
            this.loadContents(prefs);
        }
        catch (URISyntaxException | BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SourceRepositoryImpl getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<SourceRepositoryImpl> clazz = SourceRepositoryImpl.class;
        synchronized (SourceRepositoryImpl.class) {
            INSTANCE = new SourceRepositoryImpl(NbPreferences.forModule(SourceRepositoryImpl.class));
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public FileGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileGroup> getGroups() {
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            return new ArrayList<FileGroup>(this.groups.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileGroup createGroup(String displayName) throws IOException {
        FileGroup g;
        URI uri;
        String prefKey = "group." + Integer.toString(this.highestIndex++);
        try {
            uri = new URI("urn:" + prefKey);
            g = new FileGroup(uri, displayName, this);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        Preferences groupNode = this.prefs.node("groups");
        groupNode.put(prefKey, displayName);
        try {
            groupNode.sync();
        }
        catch (BackingStoreException ex) {
            throw new IOException(ex);
        }
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            this.groupKeys.put(uri, prefKey);
            this.groups.put(prefKey, g);
        }
        g.addRegisteredPath();
        this.fireChange();
        return g;
    }

    String groupPrefKey(FileGroup g) {
        return g.getURI().toString().substring(4);
    }

    void renameGroup(FileGroup g, String newName) throws IOException {
        String prefKey = this.groupPrefKey(g);
        Preferences groupNode = this.prefs.node("groups");
        groupNode.put(prefKey, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(FileGroup g) throws IOException {
        String prefKey = g.getURI().toString().substring(4);
        Preferences groupParentNode = this.prefs.node("groups");
        if (groupParentNode.get(prefKey, null) == null) {
            throw new IOException("Unknown group: " + g.getDisplayName());
        }
        List<FileRoot> orphans = g.getFileRoots();
        for (FileRoot r : orphans) {
            this.removeRoot(r);
        }
        try {
            Map<URL, FileRoot> map = this.fileRoots;
            synchronized (map) {
                this.groupKeys.remove(g.getURI());
                this.groups.remove(prefKey);
            }
            groupParentNode.remove(prefKey);
            groupParentNode.sync();
            this.fireChange();
        }
        catch (BackingStoreException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRootName(URL root, String dispName) {
        String key;
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            assert (this.fileRoots.containsKey(root));
            key = this.fileKeys.get(root);
        }
        this.prefs.node("roots/" + key).put("name", dispName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRoot(FileRoot r) throws IOException {
        FileGroup parent;
        URL u = r.getLocation();
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            String prefKey = this.fileKeys.get(u);
            try {
                if (!this.prefs.nodeExists("roots/" + prefKey)) {
                    throw new IOException("Unknown root:" + u);
                }
                Preferences n = this.prefs.node("roots").node(prefKey);
                n.removeNode();
                n.flush();
            }
            catch (BackingStoreException ex) {
                throw new IOException(ex);
            }
            parent = r.getParent();
            this.fileKeys.remove(u);
            this.fileRoots.remove(u);
        }
        parent.removeRoot(r);
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileRoot addLocation(FileObject f, String dispName, FileGroup parent) throws IOException {
        if (parent == null) {
            parent = this.defaultGroup;
        }
        if (dispName == null) {
            dispName = f.getName();
        }
        URL u = URLMapper.findURL((FileObject)f, (int)0);
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            FileRoot existing = this.fileRoots.get(u);
            if (existing != null) {
                return existing;
            }
        }
        FileRoot r = new FileRoot(this, u);
        r.setDisplayName(dispName);
        return this.addFileRoot(r, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileRoot addFileRoot(FileRoot r, FileGroup parent) throws IOException {
        String dispName = r.getDisplayName();
        URL u = r.getLocation();
        String prefKey = "root" + Integer.toString(this.highestIndex++);
        Preferences node = this.prefs.node("roots").node(prefKey);
        node.put("url", u.toString());
        node.put("name", dispName);
        if (parent != this.getDefaultGroup()) {
            String groupKey = this.groupKeys.get(parent.getURI());
            node.put("group", groupKey);
        }
        try {
            node.sync();
        }
        catch (BackingStoreException ex) {
            throw new IOException(ex);
        }
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            this.fileKeys.put(u, prefKey);
            this.fileRoots.put(u, r);
            r.setDisplayName(dispName);
            r.setParent(parent);
        }
        parent.addRoot(r);
        this.fireChange();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadContents(Preferences collection) throws BackingStoreException {
        HashMap<String, FileGroup> groups = new HashMap<String, FileGroup>();
        HashMap<URI, String> groupKeys = new HashMap<URI, String>();
        if (this.prefs.nodeExists("groups")) {
            Preferences groupNode = this.prefs.node("groups");
            for (String s : groupNode.keys()) {
                String v;
                if (!s.startsWith("group")) continue;
                int max = Integer.parseInt(s.substring(6));
                if (max > this.highestIndex) {
                    this.highestIndex = max;
                }
                if ((v = groupNode.get(s, null)) == null) continue;
                try {
                    URI groupURI = new URI("urn:" + s);
                    FileGroup g = new FileGroup(groupURI, v, this);
                    groups.put(s, g);
                    groupKeys.put(groupURI, s);
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        HashMap<URL, FileRoot> roots = new HashMap<URL, FileRoot>();
        HashMap<URL, String> keys = new HashMap<URL, String>();
        if (this.prefs.nodeExists("roots")) {
            Preferences rootsParent = this.prefs.node("roots");
            for (String s : rootsParent.childrenNames()) {
                FileRoot r;
                String v;
                if (!s.startsWith("root")) continue;
                Preferences rootNode = rootsParent.node(s);
                int max = Integer.parseInt(s.substring(4));
                if (max > this.highestIndex) {
                    this.highestIndex = max;
                }
                if ((v = rootNode.get("url", null)) == null) continue;
                try {
                    r = new FileRoot(this, new URL(v));
                    FileObject f = URLMapper.findFileObject((URL)r.getLocation());
                    String name = rootNode.get("name", f != null ? f.getName() : "<unknown>");
                    r.setDisplayName(name);
                    roots.put(r.getLocation(), r);
                    keys.put(r.getLocation(), s);
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    continue;
                }
                String parentId = rootNode.get("group", null);
                FileGroup g = null;
                if (parentId != null) {
                    g = (FileGroup)groups.get(parentId);
                }
                if (g == null) {
                    g = this.defaultGroup;
                }
                g.addRoot(r);
                r.setParent(g);
            }
        }
        this.getDefaultGroup().addRegisteredPath();
        for (FileGroup g : groups.values()) {
            g.addRegisteredPath();
        }
        Map<URL, FileRoot> map = this.fileRoots;
        synchronized (map) {
            this.groups.putAll(groups);
            this.fileRoots.putAll(roots);
            this.fileKeys.putAll(keys);
            this.groupKeys.putAll(groupKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChange() {
        ChangeListener[] ll;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    static synchronized void _testReset() {
        if (INSTANCE != null) {
            INSTANCE.getDefaultGroup().removeRegisteredPath();
            INSTANCE.getGroups().forEach(g -> g.removeRegisteredPath());
        }
        INSTANCE = null;
    }
}

