/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.actions.LocationAction;
import org.graalvm.visualizer.view.api.DiagramModel;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class GotoNodeAction
extends LocationAction {
    public static final String ACTION_ID = "org.graalvm.visualizer.source.impl.actions.GotoNodeActionn";
    public static final String CATEGORY = "CallStack";
    private final NodeLocationContext context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);

    public GotoNodeAction() {
    }

    private GotoNodeAction(Lookup lkp) {
        super(lkp);
    }

    @Override
    protected void actionPerformed(ActionEvent e, InputGraph g, InputNode[] nodes) {
        Node[] activatedNodes = this.activeNodes();
        NodeStack.Frame frame = (NodeStack.Frame)activatedNodes[0].getLookup().lookup(NodeStack.Frame.class);
        if (frame == null) {
            return;
        }
        InputNode gNode = frame.getNode();
        InputGraph graph = frame.getGraph();
        DiagramViewerLocator locator = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        if (locator == null) {
            return;
        }
        DiagramModel actModel = locator.getActiveModel();
        if (actModel == null || actModel.getGraphToView() != graph) {
            return;
        }
        GraphSelections prov = locator.getActiveViewer().getSelections();
        prov.setSelectedNodes(Collections.singleton(gNode));
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new GotoNodeAction(lkp);
    }
}

