/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.impl.actions.Bundle;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.ProxyLookup;

public class PreferGuestLanguageAction
extends AbstractAction
implements ActionListener,
ContextAwareAction,
Presenter.Toolbar,
PropertyChangeListener {
    public static final String ACTION_ID = "org.graalvm.visualizer.source.impl.actions.PreferGuestLanguageAction";
    public static final String CATEGORY = "CallStack";
    private final NodeLocationContext context;
    private Reference<JToggleButton> buttonRef = new WeakReference<Object>(null);
    private Icon smallIcon;

    public PreferGuestLanguageAction() {
        this.context = null;
    }

    private PreferGuestLanguageAction(Lookup lkp) {
        boolean en;
        this.context = (NodeLocationContext)lkp.lookup(NodeLocationContext.class);
        boolean bl = en = this.context != null && this.context.isPreferGuestLanguage();
        if (this.context != null) {
            this.context.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.context));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.context == null) {
            return;
        }
        this.context.setPreferGuestLanguage(!this.context.isPreferGuestLanguage());
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new PreferGuestLanguageAction((Lookup)new ProxyLookup(new Lookup[]{lkp, Lookup.getDefault()}));
    }

    public Component getToolbarPresenter() {
        JToggleButton toggleButton = new JToggleButton();
        this.buttonRef = new WeakReference<JToggleButton>(toggleButton);
        toggleButton.putClientProperty("hideActionText", Boolean.TRUE);
        toggleButton.setIcon((Icon)this.getValue("SmallIcon"));
        toggleButton.setAction(this);
        this.updateState();
        return toggleButton;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"preferGuestLanguage".equals(evt.getPropertyName())) {
            return;
        }
        this.updateState();
    }

    private void updateState() {
        JToggleButton b = this.buttonRef.get();
        if (b != null) {
            b.setSelected(this.context.isPreferGuestLanguage());
        }
    }

    private Icon getIcon() {
        if (this.smallIcon != null) {
            return this.smallIcon;
        }
        String r = this.iconResource();
        if (r == null) {
            return null;
        }
        this.smallIcon = ImageUtilities.loadImageIcon((String)r, (boolean)true);
        return this.smallIcon;
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/source/resources/preferGuest.png";
    }

    public String getName() {
        return Bundle.ACTION_PreferGuestLanguage();
    }

    @Override
    public Object getValue(String key) {
        switch (key) {
            case "SmallIcon": {
                return this.getIcon();
            }
            case "ShortDescription": {
                return this.getName();
            }
            case "Name": {
                return this.getName();
            }
        }
        return super.getValue(key);
    }
}

