/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeLocationEvent;
import org.graalvm.visualizer.source.NodeLocationListener;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class NodeStackHighlight
extends AbstractHighlightsContainer
implements HighlightsChangeListener,
NodeLocationListener {
    private static final String HIGHLIGHT_STACK_CURRENT = "highlight-compiled-lines";
    private static final String HIGHLIGHT_NESTED_LINES = "highlight-nested-lines";
    private static final String LAYER_ID = NodeStackHighlight.class.getName();
    private final OffsetsBag bag;
    private final Document document;
    private final NodeLocationContext locationContext;
    private final MimePath mimePath;
    private static RequestProcessor RP = new RequestProcessor(NodeStackHighlight.class);

    public NodeStackHighlight(JTextComponent component) {
        this.document = component.getDocument();
        this.bag = new OffsetsBag(this.document);
        this.locationContext = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        String mimeType = DocumentUtilities.getMimeType((Document)this.document);
        this.mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.bag.addHighlightsChangeListener((HighlightsChangeListener)this);
        this.locationContext.addNodeLocationListener((NodeLocationListener)WeakListeners.create(NodeLocationListener.class, (EventListener)this, (Object)this.locationContext));
        this.refresh();
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return this.bag.getHighlights(startOffset, endOffset);
    }

    public void highlightChanged(HighlightsChangeEvent event) {
        this.fireHighlightsChange(event.getStartOffset(), event.getEndOffset());
    }

    @Override
    public void selectedNodeChanged(NodeLocationEvent evt) {
    }

    @Override
    public void nodesChanged(NodeLocationEvent evt) {
    }

    @Override
    public void locationsResolved(NodeLocationEvent evt) {
        this.refresh();
    }

    @Override
    public void selectedLocationChanged(NodeLocationEvent evt) {
        FileObject file = EditorDocumentUtils.getFileObject((Document)this.document);
        if (file == null) {
            return;
        }
        Location loc = evt.getContext().getSelectedLocation();
        if (loc == null || !file.equals(loc.getOriginFile())) {
            return;
        }
        this.refresh();
    }

    private void refresh() {
        RP.post(() -> this.document.render(this::doRefresh));
    }

    private void doRefresh() {
        FileObject file = EditorDocumentUtils.getFileObject((Document)this.document);
        if (file == null) {
            return;
        }
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)this.document, LineDocument.class);
        if (ld == null) {
            return;
        }
        Location current = this.locationContext.getSelectedLocation();
        if (current == null) {
            return;
        }
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attribCurrent = fcs.getFontColors(HIGHLIGHT_STACK_CURRENT);
        AttributeSet attribNested = fcs.getFontColors(HIGHLIGHT_NESTED_LINES);
        OffsetsBag newBag = new OffsetsBag(this.document);
        ArrayList<Location> locs = new ArrayList<Location>(this.locationContext.getFileLocations(file, false));
        HashSet<Location> locs2 = new HashSet<Location>(this.locationContext.getFileLocations(file, true));
        Collections.sort(locs, (a, b) -> a.getLine() - b.getLine());
        Element paragraphParent = ld.getParagraphElement(0).getParentElement();
        int count = paragraphParent.getElementCount();
        for (Location l : locs) {
            int line = l.getLine();
            if (line < 1 || line >= count) continue;
            Element lineEl = paragraphParent.getElement(line - 1);
            AttributeSet as = locs2.contains(l) ? attribCurrent : attribNested;
            int s = lineEl.getStartOffset();
            int e = lineEl.getEndOffset();
            newBag.addHighlight(s, e, as);
        }
        this.bag.setHighlights(newBag);
    }

    public static final class Factory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)LAYER_ID, (ZOrder)ZOrder.BOTTOM_RACK, (boolean)true, (HighlightsContainer)new NodeStackHighlight(context.getComponent()))};
        }
    }
}

