/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.SourceRepositoryNode;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ChoiceView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RootPlacementUI
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    private String autoDescriptionString;
    private final JFileChooser chooser;
    private final SourceRepositoryImpl impl;
    private final ExplorerManager mgr = new ExplorerManager();
    private static final Pattern EXCLUDE_FILENAMES = Pattern.compile("main|java|src.*|classes.*");
    private JComboBox<String> cbGroup;
    private JLabel jLabel1;
    private JLabel lblGroup;
    private JTextField txDescription;

    public RootPlacementUI(JFileChooser chooser, SourceRepositoryImpl impl) throws FileStateInvalidException {
        this.impl = impl;
        this.chooser = chooser;
        this.initComponents();
        chooser.addPropertyChangeListener(this);
        SourceRepositoryNode rNode = new SourceRepositoryNode(impl, true);
        FilterNode.Children fChildren = new FilterNode.Children((Node)rNode){

            protected Node[] createNodes(Node key) {
                if (key.getLookup().lookup(FileGroup.class) == null) {
                    return null;
                }
                return new Node[]{new FilterNode(key, Children.LEAF)};
            }
        };
        AbstractNode an = new AbstractNode((Children)fChildren);
        this.mgr.setRootContext((Node)an);
        this.txDescription.setEditable(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.showHideGroupControls();
    }

    void setFileGroup(FileGroup g) {
        if (g == null) {
            Node[] nodes = this.mgr.getRootContext().getChildren().getNodes();
            if (nodes.length == 0) {
                return;
            }
            g = this.impl.getDefaultGroup();
        }
        for (Node n : this.mgr.getRootContext().getChildren().getNodes()) {
            FileGroup ng = (FileGroup)n.getLookup().lookup(FileGroup.class);
            if (ng != g) continue;
            try {
                this.mgr.setSelectedNodes(new Node[]{n});
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
    }

    private void showHideGroupControls() {
        if (this.cbGroup.getModel().getSize() < 2) {
            this.cbGroup.setVisible(false);
            this.lblGroup.setVisible(false);
        } else {
            this.cbGroup.setVisible(true);
            this.lblGroup.setVisible(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            this.updateDescriptionField();
        }
    }

    private void updateDescriptionField() {
        File parent;
        String s = this.txDescription.getText();
        if (this.autoDescriptionString != null && !this.autoDescriptionString.equals(s)) {
            return;
        }
        File f = this.chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        String fn = f.getName();
        if (!EXCLUDE_FILENAMES.matcher(fn).matches()) {
            this.autoDescriptionString = fn;
            this.txDescription.setText(fn);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(f.getName());
        for (parent = f.getParentFile(); parent != null && EXCLUDE_FILENAMES.matcher(parent.getName()).matches(); parent = parent.getParentFile()) {
            sb.insert(0, parent.getName() + "/");
        }
        this.autoDescriptionString = parent == null || parent.getName().isEmpty() ? sb.toString() : Bundle.FMT_AutomaticComposedName(parent.getName(), sb.toString());
        this.txDescription.setText(this.autoDescriptionString);
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr;
    }

    private FileObject getSelectedRoot() {
        File f = this.chooser.getSelectedFile();
        return f == null ? null : FileUtil.toFileObject((File)f);
    }

    public String getDescription() {
        String s = this.txDescription.getText();
        if (s.isEmpty()) {
            s = this.getSelectedRoot().getName();
        }
        return s;
    }

    public FileGroup getParentGroup() {
        Node[] n = this.mgr.getSelectedNodes();
        return n == null || n.length == 0 ? null : (FileGroup)n[0].getLookup().lookup(FileGroup.class);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txDescription = new JTextField();
        this.lblGroup = new JLabel();
        this.cbGroup = new ChoiceView();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RootPlacementUI.class, (String)"RootPlacementUI.jLabel1.text"));
        this.txDescription.setText(NbBundle.getMessage(RootPlacementUI.class, (String)"RootPlacementUI.txDescription.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblGroup, (String)NbBundle.getMessage(RootPlacementUI.class, (String)"RootPlacementUI.lblGroup.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.lblGroup)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txDescription).addComponent(this.cbGroup, 0, 294, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbGroup, -2, -1, -2).addComponent(this.lblGroup)).addGap(0, 18, Short.MAX_VALUE)));
    }
}

