/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeLocationEvent;
import org.graalvm.visualizer.source.NodeLocationListener;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.ui.BasicLocatorUI;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.graalvm.visualizer.source.impl.ui.CompactComboRenderer;
import org.graalvm.visualizer.source.impl.ui.CompactComboUI;
import org.graalvm.visualizer.source.spi.LocatorUI;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.graalvm.visualizer.util.swing.DropdownButton;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.Toolbar;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ChoiceView;
import org.openide.explorer.view.NodeListModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="StackView", iconBase="org/graalvm/visualizer/source/resources/callview.png", persistenceType=0)
public final class StackViewTopComponent
extends TopComponent
implements ExplorerManager.Provider,
NodeLocationListener,
PropertyChangeListener {
    private final NodeLocationContext locContext;
    private final ExplorerManager manager = new ExplorerManager();
    private final ChoiceView choiceView;
    private List<InputNode> orderedContextNodes = new ArrayList<InputNode>();
    private final LangSelector lSelector;
    private final InstanceContent exportContent = new InstanceContent();
    private boolean ignorePropChange;
    private JButton attach;
    private JPanel contextPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel langDrop;
    private JPanel noSourcesPanel;
    private JComboBox<String> nodeSelector;
    private JPanel outerPanel;
    private JPanel selectionPanel;
    private JToolBar toolBar;
    AbstractNode noContextNode;
    private boolean nodesChanging;
    private NodeStack.Frame current;
    private Language frameLanguage;
    private Collection<String> languages = Collections.emptyList();
    private JPopupMenu resolverMenu;
    static final Object KEY = new Object();
    private Reference<InputGraph> graphNotified = new WeakReference<Object>(null);

    public StackViewTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ProcessingViewTopComponent());
        this.setToolTipText(Bundle.HINT_ProcessingViewTopComponent());
        Lookup lkp = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap());
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.toolBar.setBorder(b);
        this.locContext = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        this.choiceView = new ChoiceView(){

            public void updateUI() {
                this.setUI(new CompactComboUI());
                ListCellRenderer renderer = this.getRenderer();
                if (renderer instanceof Component) {
                    SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
                }
            }
        };
        this.choiceView.setRenderer((ListCellRenderer)((Object)new CompactComboRenderer()));
        ((NodeListModel)this.choiceView.getModel()).setDepth(50);
        this.selectionPanel.add((Component)this.choiceView, "Center");
        this.nodeSelector.setRenderer(new InputNodeRenderer());
        this.nodeSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InputNode in = (InputNode)StackViewTopComponent.this.nodeSelector.getSelectedItem();
                if (in == null) {
                    return;
                }
                StackViewTopComponent.this.updateActivatedNodes();
                NodeStack ns = StackViewTopComponent.this.findFrameForNode(in);
                if (ns != null) {
                    StackViewTopComponent.this.updateComboContents(ns);
                }
            }
        });
        this.lSelector = (LangSelector)((Object)this.langDrop);
        this.locContext.addNodeLocationListener(this);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.displayNoContext();
        this.addAction("CallStack", "org.graalvm.visualizer.source.impl.actions.GotoSourceAction1", lkp);
        this.addAction("CallStack", "org.graalvm.visualizer.source.impl.actions.GoStackUp", lkp);
        this.addAction("CallStack", "org.graalvm.visualizer.source.impl.actions.GoStackDown", lkp);
        this.addAction("CallStack", "org.graalvm.visualizer.source.impl.actions.GotoNodeActionn", lkp);
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.exportContent));
        this.lSelector.setPopupToolTipText(Bundle.TOOLTIP_LanguageDropDown());
    }

    private void addAction(String category, String id, Lookup lkp) {
        Action a = Actions.forID((String)category, (String)id);
        if (a == null) {
            return;
        }
        if (a instanceof ContextAwareAction) {
            a = ((ContextAwareAction)a).createContextAwareInstance(lkp);
        }
        if (a instanceof Presenter.Toolbar) {
            this.toolBar.add(((Presenter.Toolbar)a).getToolbarPresenter());
        } else {
            this.toolBar.add(a);
        }
    }

    private static String getHTMLColorString(Color color) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        return "#" + (String)(red.length() == 1 ? "0" + red : red) + (String)(green.length() == 1 ? "0" + green : green) + (String)(blue.length() == 1 ? "0" + blue : blue);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.outerPanel = new JPanel();
        this.contextPanel = new JPanel();
        this.toolBar = new Toolbar();
        this.jLabel2 = new JLabel();
        this.nodeSelector = new JComboBox();
        this.langDrop = new LangSelector();
        this.attach = new JButton();
        this.selectionPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.noSourcesPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.setPreferredSize(new Dimension(200, 102));
        this.outerPanel.setPreferredSize(new Dimension(200, 100));
        this.outerPanel.setLayout(new CardLayout());
        this.toolBar.setRollover(true);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(StackViewTopComponent.class, (String)"StackViewTopComponent.jLabel2.text"));
        GroupLayout langDropLayout = new GroupLayout(this.langDrop);
        this.langDrop.setLayout(langDropLayout);
        langDropLayout.setHorizontalGroup(langDropLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        langDropLayout.setVerticalGroup(langDropLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.attach.setIcon(new ImageIcon(this.getClass().getResource("/org/graalvm/visualizer/source/resources/find.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.attach, (String)NbBundle.getMessage(StackViewTopComponent.class, (String)"StackViewTopComponent.attach.text"));
        this.attach.setToolTipText(NbBundle.getMessage(StackViewTopComponent.class, (String)"StackViewTopComponent.attach.toolTipText"));
        this.attach.setBorder(null);
        this.attach.setFocusable(false);
        this.attach.setHorizontalTextPosition(0);
        this.attach.setVerticalTextPosition(3);
        this.attach.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StackViewTopComponent.this.attachActionPerformed(evt);
            }
        });
        this.selectionPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(StackViewTopComponent.class, (String)"StackViewTopComponent.jLabel3.text"));
        this.jLabel3.setToolTipText(NbBundle.getMessage(StackViewTopComponent.class, (String)"StackViewTopComponent.jLabel3.toolTipText"));
        this.jLabel3.setOpaque(true);
        this.selectionPanel.add((Component)this.jLabel3, "Center");
        GroupLayout contextPanelLayout = new GroupLayout(this.contextPanel);
        this.contextPanel.setLayout(contextPanelLayout);
        contextPanelLayout.setHorizontalGroup(contextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextPanelLayout.createSequentialGroup().addContainerGap().addGroup(contextPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.langDrop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextPanelLayout.createSequentialGroup().addComponent(this.attach, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.nodeSelector, 0, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(contextPanelLayout.createSequentialGroup().addComponent(this.toolBar, -1, -1, Short.MAX_VALUE).addGap(193, 193, 193)));
        contextPanelLayout.setVerticalGroup(contextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contextPanelLayout.createSequentialGroup().addComponent(this.toolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(contextPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addGap(18, 18, 18).addGroup(contextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.attach, -1, 26, Short.MAX_VALUE).addComponent(this.langDrop, -1, -1, Short.MAX_VALUE))).addGroup(contextPanelLayout.createSequentialGroup().addComponent(this.nodeSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        this.outerPanel.add((Component)this.contextPanel, "sourceContext");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(StackViewTopComponent.class, (String)"StackViewTopComponent.jLabel1.text"));
        GroupLayout noSourcesPanelLayout = new GroupLayout(this.noSourcesPanel);
        this.noSourcesPanel.setLayout(noSourcesPanelLayout);
        noSourcesPanelLayout.setHorizontalGroup(noSourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noSourcesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        noSourcesPanelLayout.setVerticalGroup(noSourcesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noSourcesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        this.outerPanel.add((Component)this.noSourcesPanel, "noSources");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outerPanel, -1, 211, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outerPanel, -1, 102, Short.MAX_VALUE));
    }

    private void attachActionPerformed(ActionEvent evt) {
        JPopupMenu menu = this.buildResolverMenu();
        Rectangle bbounds = this.attach.getBounds();
        menu.show((Component)((Object)this), bbounds.x, bbounds.y + bbounds.height);
    }

    private NodeStack.Frame findCurrentFrame() {
        NodeStack.Frame frame = this.locContext.getSelectedFrame();
        if (frame == null) {
            if (this.frameLanguage == null) {
                return null;
            }
            Node[] selNodes = this.getExplorerManager().getSelectedNodes();
            if (selNodes.length > 0) {
                frame = (NodeStack.Frame)selNodes[0].getLookup().lookup(NodeStack.Frame.class);
            }
        }
        return frame;
    }

    private void selectLanguage() {
        String mime;
        if (this.languages.size() < 2) {
            return;
        }
        NodeStack.Frame frame = this.locContext.getSelectedFrame();
        if (frame == null) {
            if (this.frameLanguage == null) {
                return;
            }
            mime = this.frameLanguage.getMimeType();
            Node[] selNodes = this.getExplorerManager().getSelectedNodes();
            if (selNodes.length > 0) {
                frame = (NodeStack.Frame)selNodes[0].getLookup().lookup(NodeStack.Frame.class);
            }
        } else {
            mime = frame.getLocation().getMimeType();
        }
        if (frame == null) {
            return;
        }
        NodeStack firstStack = null;
        NodeStack.Frame nframe = null;
        for (String m : this.languages) {
            if (m.equals(mime)) continue;
            nframe = frame.findPeerFrame(m);
            if (nframe != null) break;
            if (firstStack != null) continue;
            firstStack = frame.getStack().getOtherStack(m);
        }
        if (nframe == null && firstStack != null) {
            nframe = firstStack.top();
        }
        if (nframe != null) {
            this.locContext.setSelectedLocation(nframe);
        }
    }

    Node findNode(NodeStack.Frame frame) {
        ArrayDeque<Node> toCheck = new ArrayDeque<Node>();
        toCheck.add(this.manager.getRootContext());
        while (!toCheck.isEmpty()) {
            Node n = (Node)toCheck.poll();
            NodeStack.Frame l = (NodeStack.Frame)n.getLookup().lookup(NodeStack.Frame.class);
            if (frame.equals(l)) {
                return n;
            }
            toCheck.addAll(Arrays.asList(n.getChildren().getNodes()));
        }
        return null;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(java.util.Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
    }

    void displayNoContext() {
        if (this.noContextNode == null) {
            this.noContextNode = new AbstractNode(Children.LEAF);
            this.noContextNode.setName(Bundle.LBL_NoSourceContext());
            this.noContextNode.setDisplayName(Bundle.LBL_NoSourceContext());
        }
        try {
            this.ignorePropChange = true;
            this.manager.setRootContext((Node)this.noContextNode);
            this.manager.setExploredContext((Node)this.noContextNode);
            this.choiceView.setShowExploredContext(true);
            this.manager.setSelectedNodes(new Node[]{this.noContextNode});
            this.choiceView.setEnabled(false);
            this.choiceView.setSelectedItem(null);
            ((CardLayout)this.outerPanel.getLayout()).show(this.outerPanel, "noSources");
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            this.ignorePropChange = false;
        }
    }

    private NodeStack findFrameForNode(InputNode n) {
        String lng;
        NodeStack locs = null;
        String string = lng = this.frameLanguage == null ? this.locContext.getSelectedLanguage() : this.frameLanguage.getMimeType();
        if (lng != null && (locs = this.locContext.getStack(n, lng)) != null) {
            return locs;
        }
        if (n == null) {
            return null;
        }
        boolean preferGuest = this.locContext.isPreferGuestLanguage();
        GraphSource gSource = this.locContext.getGraphSource();
        if (gSource == null) {
            return null;
        }
        if (gSource.getGraph().getNode(n.getId()) != n) {
            return null;
        }
        List<String> availLangs = gSource.getStackLanguages(n.getId());
        NodeStack first = null;
        for (String m : availLangs) {
            boolean guest;
            Language l = Language.getRegistry().findLanguageByMime(m);
            if (l == null) continue;
            boolean bl = guest = !l.isHostLanguage();
            locs = this.locContext.getStack(n, m);
            if (locs == null) continue;
            if (first == null) {
                first = locs;
            }
            if (preferGuest != guest) continue;
            return locs;
        }
        return first;
    }

    @Override
    public void selectedNodeChanged(NodeLocationEvent evt) {
        InputNode n = evt.getSelectedNode();
        this.doNodeChange(evt.getNodes(), n);
    }

    private void updateNodeSelector(Collection<InputNode> nodes, InputNode cur) {
        if (nodes == null || nodes.isEmpty()) {
            this.nodeSelector.setEnabled(false);
            return;
        }
        this.orderedContextNodes = new ArrayList<InputNode>(nodes);
        Collections.sort(this.orderedContextNodes, InputNode.COMPARATOR);
        DefaultComboBoxModel<InputNode> mdl = new DefaultComboBoxModel<InputNode>(this.orderedContextNodes.toArray(new InputNode[this.orderedContextNodes.size()]));
        this.nodeSelector.setModel(mdl);
        int idx = this.orderedContextNodes.indexOf(cur);
        if (idx != -1) {
            this.nodeSelector.setSelectedIndex(idx);
        }
        if (cur != null) {
            this.updateActivatedNodes();
        }
    }

    private void updateActivatedNodes() {
        Object o = this.nodeSelector.getSelectedItem();
        if (o == null && this.nodeSelector.getItemCount() > 0) {
            o = this.nodeSelector.getModel().getElementAt(0);
        }
        if (o instanceof Properties.Provider) {
            final Properties.Provider provider = (Properties.Provider)o;
            AbstractNode node = new AbstractNode(Children.LEAF, Lookup.EMPTY){

                protected Sheet createSheet() {
                    Sheet s = super.createSheet();
                    PropertiesSheet.initializeSheet((Properties)provider.getProperties(), (Sheet)s);
                    return s;
                }
            };
            node.setDisplayName(provider.getProperties().getString("name", ""));
            this.setActivatedNodes(new Node[]{node});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNodeChange(Collection<InputNode> inputNodes, InputNode n) {
        this.nodesChanging = true;
        try {
            NodeStack locs = this.findFrameForNode(n);
            if (locs == null || locs.isEmpty()) {
                this.current = null;
                this.displayNoContext();
                return;
            }
            this.updateNodeSelector(inputNodes, n);
            this.updateComboContents(locs);
        }
        finally {
            this.nodesChanging = false;
        }
    }

    @Override
    public void nodesChanged(NodeLocationEvent evt) {
        Collection<InputNode> inputNodes = this.locContext.getGraphNodes();
        if (inputNodes.isEmpty()) {
            this.current = null;
            this.displayNoContext();
            return;
        }
        InputNode n = this.locContext.getCurrentNode();
        if (!(n != null || (n = (InputNode)this.nodeSelector.getSelectedItem()) != null && evt.getNodes().contains(n))) {
            ArrayList<InputNode> candidates = new ArrayList<InputNode>(inputNodes);
            Collections.sort(candidates, InputNode.COMPARATOR);
            n = (InputNode)candidates.iterator().next();
        }
        this.doNodeChange(inputNodes, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComboContents(NodeStack locs) {
        ChainNode node;
        Node r;
        NodeStack.Frame f;
        Enumeration en;
        Node n = this.manager.getRootContext();
        if (n != null && (en = n.getChildren().nodes()).hasMoreElements() && (f = (NodeStack.Frame)(r = (Node)en.nextElement()).getLookup().lookup(NodeStack.Frame.class)) != null && f.getStack() == locs) {
            return;
        }
        int indentLevel = 24;
        Children.Array arr = new Children.Array();
        for (int i = locs.size() - 1; i > 24; --i) {
            NodeStack.Frame frame = locs.get(i);
            node = new ChainNode(frame, (Node)frame.getLookup().lookup(Node.class), Children.LEAF);
            arr.add(new Node[]{node});
        }
        NodeStack.Frame head = locs.size() > 24 ? locs.get(24) : locs.bottom();
        Object children = head.getNested() == null ? Children.LEAF : new ChainChildren(head);
        node = new ChainNode(head, (Node)head.getLookup().lookup(Node.class), (Children)children);
        arr.add(new Node[]{node});
        this.manager.setRootContext((Node)new AbstractNode((Children)arr));
        Node toSelect = this.findNode(locs.top());
        List<String> langs = head.getGraphSource().getStackLanguages(head.getNode().getId());
        Language lng = Language.getRegistry().findLanguageByMime(head.getLocation().getMimeType());
        Node ln = (Node)lng.getLookup().lookup(Node.class);
        if (ln != null) {
            this.lSelector.setIcon(ImageUtilities.image2Icon((Image)ln.getIcon(1)));
        }
        this.languages = langs;
        this.frameLanguage = lng;
        this.lSelector.setEnabled(langs.size() > 1);
        this.lSelector.setToolTipText(Bundle.TOOLTIP_CurrentLanguage(lng.getDisplayName()));
        try {
            this.ignorePropChange = true;
            this.choiceView.setShowExploredContext(false);
            if (toSelect != null) {
                this.manager.setSelectedNodes(new Node[]{toSelect});
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.ignorePropChange = false;
        }
        this.current = locs.top();
        this.choiceView.setEnabled(true);
        ((CardLayout)this.outerPanel.getLayout()).show(this.outerPanel, "sourceContext");
        NodeStack.Frame frame = this.getSelectedFrame();
        Location l = frame.getLocation();
        if (l != null && !l.isResolved()) {
            this.notifyProjectSearch();
        }
    }

    @Override
    public void locationsResolved(NodeLocationEvent evt) {
        if (this.current != null && evt.getNodes().contains(this.current.getNode())) {
            this.refreshButtons();
        }
    }

    @Override
    public void selectedLocationChanged(NodeLocationEvent evt) {
        NodeStack.Frame loc = evt.getSelectedFrame();
        if (loc == null || loc.equals(this.current) || this.ignorePropChange) {
            return;
        }
        String mime = loc.getLocation().getMimeType();
        if (this.frameLanguage == null || !Objects.equals(this.frameLanguage.getMimeType(), mime)) {
            this.updateComboContents(loc.getStack());
        }
        this.current = loc;
        Node n = this.findNode(loc);
        if (n != null && !this.ignorePropChange) {
            try {
                this.manager.setSelectedNodes(new Node[]{n});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"selectedNodes".equals(evt.getPropertyName())) {
            return;
        }
        this.resolverMenu = null;
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes.length == 0) {
            return;
        }
        this.refreshButtons();
        NodeStack.Frame loc = (NodeStack.Frame)nodes[0].getLookup().lookup(NodeStack.Frame.class);
        if (this.nodesChanging) {
            return;
        }
        if (loc != null && !loc.isResolved()) {
            this.notifyProjectSearch();
        }
        this.locContext.setSelectedLocation(loc);
    }

    private void refreshButtons() {
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes.length == 0) {
            return;
        }
        NodeStack.Frame loc = (NodeStack.Frame)nodes[0].getLookup().lookup(NodeStack.Frame.class);
        if (loc != null) {
            this.attach.setVisible(!loc.isResolved());
        }
    }

    private NodeStack.Frame getSelectedFrame() {
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes.length == 0) {
            return null;
        }
        return (NodeStack.Frame)nodes[0].getLookup().lookup(NodeStack.Frame.class);
    }

    private JPopupMenu buildResolverMenu() {
        if (this.resolverMenu != null) {
            return this.resolverMenu;
        }
        NodeStack.Frame frame = this.getSelectedFrame();
        final Location l = frame.getLocation();
        JPopupMenu popup = new JPopupMenu();
        ArrayList locatorUIs = new ArrayList(Lookup.getDefault().lookupAll(LocatorUI.class));
        Iterator it = locatorUIs.iterator();
        while (it.hasNext()) {
            final LocatorUI ui = (LocatorUI)it.next();
            if (!ui.accepts(l)) {
                it.remove();
                continue;
            }
            JMenuItem jmi = new JMenuItem(ui.getDisplayName(), ImageUtilities.image2Icon((Image)ui.getIcon()));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ui.resolve(l);
                }
            });
            popup.add(jmi);
        }
        if (popup.getSubElements().length == 0) {
            JMenuItem jmi = new JMenuItem(Bundle.LBL_NoResolversFound());
            jmi.setEnabled(false);
            popup.add(jmi);
        }
        this.resolverMenu = popup;
        return popup;
    }

    private void notifyProjectSearch() {
        InputGraph seen = this.graphNotified.get();
        InputGraph now = this.locContext.getGraph();
        if (now == null || now == seen) {
            return;
        }
        NodeStack.Frame frame = this.getSelectedFrame();
        Location l = frame.getLocation();
        if (l == null) {
            return;
        }
        NotificationDisplayer.getDefault().notify(Bundle.TITLE_UnknownSources(), (Icon)ImageUtilities.loadImageIcon((String)"org/graalvm/visualizer/source/resources/find.png", (boolean)false), Bundle.HINT_SearchForSources(l.getFile().getFileSpec()), this::searchInSpecificLocator);
        this.graphNotified = new WeakReference<InputGraph>(now);
    }

    private void searchInSpecificLocator(ActionEvent ev) {
        NodeStack.Frame frame = this.getSelectedFrame();
        Location l = frame.getLocation();
        ArrayList locatorUIs = new ArrayList(Lookup.getDefault().lookupAll(LocatorUI.class));
        for (LocatorUI ui : locatorUIs) {
            if (ui instanceof BasicLocatorUI || !ui.accepts(l)) continue;
            ui.resolve(l);
        }
    }

    class InputNodeRenderer
    extends DefaultListCellRenderer {
        InputNodeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DiagramViewer viewer;
            Collection figs;
            JLabel lab = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof InputNode)) {
                return lab;
            }
            InputNode nn = (InputNode)value;
            InputGraph g = StackViewTopComponent.this.locContext.getGraph();
            if (g == null) {
                return lab;
            }
            DiagramViewerLocator loc = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
            List vwrs = loc.find(g);
            if (!vwrs.isEmpty() && !(figs = (viewer = (DiagramViewer)vwrs.iterator().next()).figuresForNodes(Collections.singleton(nn))).isEmpty()) {
                Figure f = (Figure)figs.iterator().next();
                String s = f.getProperties().getString("name", Bundle.LAB_NodeNoName());
                s = s.replace("<", "&lt;");
                lab.setText(Bundle.FMT_InputNodeLabel(nn.getId(), s));
            }
            return lab;
        }
    }

    class LangSelector
    extends DropdownButton {
        LangSelector() {
            super("", null, false);
        }

        protected void performAction(ActionEvent e) {
            StackViewTopComponent.this.selectLanguage();
        }

        protected void populatePopup(JPopupMenu menu) {
            for (String l : StackViewTopComponent.this.languages) {
                Language lng = Language.getRegistry().findLanguageByMime(l);
                if (lng == null) continue;
                Icon icon = null;
                Node ln = (Node)lng.getLookup().lookup(Node.class);
                if (ln != null) {
                    icon = ImageUtilities.image2Icon((Image)ln.getIcon(1));
                }
                JMenuItem mi = new JMenuItem(lng.getDisplayName(), icon);
                mi.addActionListener(e -> {
                    NodeStack.Frame nframe;
                    NodeStack.Frame frame = StackViewTopComponent.this.findCurrentFrame();
                    NodeStack.Frame frame2 = nframe = frame == null ? null : frame.findPeerFrame(l);
                    if (nframe != null) {
                        StackViewTopComponent.this.locContext.setSelectedLocation(nframe);
                    }
                    StackViewTopComponent.this.locContext.setSelectedLanguage(l);
                });
                menu.add(mi);
            }
        }
    }

    static class ChainNode
    extends FilterNode {
        public ChainNode(NodeStack.Frame loc, Node original, Children children) {
            super(original, children, (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{loc, loc.getLocation()}), loc.getLookup()}));
            this.disableDelegation(597);
        }
    }

    static class ChainChildren
    extends Children.Keys {
        private final NodeStack.Frame loc;

        public ChainChildren(NodeStack.Frame child) {
            this.loc = child;
            this.setKeys(new Object[]{KEY});
        }

        protected Node[] createNodes(Object key) {
            if (key == KEY) {
                NodeStack.Frame nested = this.loc.getNested();
                if (nested == null) {
                    return new Node[0];
                }
                Node n = (Node)nested.getLookup().lookup(Node.class);
                if (n == null) {
                    return new Node[0];
                }
                return new Node[]{new ChainNode(nested, n, (Children)(nested.getNested() == null ? Children.LEAF : new ChainChildren(nested)))};
            }
            return null;
        }
    }
}

