/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.lang;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.impl.ui.LanguageNode;
import org.graalvm.visualizer.source.spi.LanguageProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.StatusDecorator;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class DefaultLanguageProvider
implements LanguageProvider,
InstanceContent.Convertor {
    private static final String ATTR_MIME_TYPE = "mimetype";
    private static final String UNKNOWN_MIME_PREFIX = "content/x-unknown-";
    private static final String LANGUAGES_PATH = "IGV/Languages";
    private static final DefaultLanguageProvider INSTANCE = new DefaultLanguageProvider();

    public Object convert(Object t) {
        return new LanguageNode((Language)t);
    }

    public Class type(Object t) {
        return Node.class;
    }

    public String id(Object t) {
        return ((Language)t).getGraalID();
    }

    public String displayName(Object t) {
        return ((Language)t).getDisplayName();
    }

    public static DefaultLanguageProvider getInstance() {
        return INSTANCE;
    }

    public Language createLanguage(String graalID) {
        return this.createLanguage(graalID, graalID, UNKNOWN_MIME_PREFIX + graalID);
    }

    private Language createLanguage(String id, String disp, String mime) {
        InstanceContent ic = new InstanceContent();
        AbstractLookup lkp = new AbstractLookup((AbstractLookup.Content)ic);
        Language lng = new Language(id, mime, disp, (Lookup)lkp);
        ic.add((Object)lng, (InstanceContent.Convertor)this);
        return lng;
    }

    @Override
    public Collection<Language> findSupportedLanguages() {
        FileSystem fs;
        FileObject folder = FileUtil.getConfigFile((String)LANGUAGES_PATH);
        if (folder == null) {
            return Collections.emptyList();
        }
        try {
            fs = folder.getFileSystem();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
        StatusDecorator decorator = fs.getDecorator();
        ArrayList<Language> result = new ArrayList<Language>();
        for (FileObject reg : folder.getChildren()) {
            Object m;
            if (!reg.isFolder() || !((m = reg.getAttribute(ATTR_MIME_TYPE)) instanceof String)) continue;
            String mime = m.toString();
            String id = reg.getName();
            String disp = decorator.annotateName(id, Collections.singleton(reg));
            result.add(this.createLanguage(id, disp, mime));
        }
        return result;
    }

    @Override
    public boolean isExecutable(Language l) {
        return false;
    }
}

