/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.ui;

import java.awt.Image;
import java.util.EventListener;
import java.util.function.Function;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.ui.LocationOpener;
import org.graalvm.visualizer.source.ui.Bundle;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.actions.Viewable;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public final class DefaultFrameNode
extends AbstractNode {
    private final NodeStack.Frame frame;
    private final Function<Location, String> htmlNameSupplier;
    private final Node langNode;
    private FileRegistry.FileRegistryListener regListener;
    private FileRegistry.FileRegistryListener wL;

    public DefaultFrameNode(NodeStack.Frame frame, Function<Location, String> htmlNameSupplier, Children children, Lookup lookup) {
        super(children, (Lookup)DefaultFrameNode.createLookup(lookup));
        this.frame = frame;
        this.htmlNameSupplier = htmlNameSupplier;
        PL lkp = (PL)this.getLookup();
        InstanceContent ic = lkp.content;
        ic.add((Object)frame);
        ic.add((Object)frame.getLocation());
        ic.add((Object)frame.getNode());
        ic.add((Object)this);
        ic.add(Openable.class, (InstanceContent.Convertor)lkp);
        ic.add(Viewable.class, (InstanceContent.Convertor)lkp);
        this.setName(Bundle.Format_NodeName(frame.getFileName(), null, frame.getLine()));
        Language lng = Language.getRegistry().findLanguageByMime(frame.getStack().getMime());
        this.langNode = (Node)lng.getLookup().lookup(Node.class);
    }

    public Image getIcon(int type) {
        if (this.langNode != null) {
            return this.langNode.getIcon(type);
        }
        return super.getIcon(type);
    }

    private static PL createLookup(Lookup additional) {
        InstanceContent content = new InstanceContent();
        AbstractLookup inner = new AbstractLookup((AbstractLookup.Content)content);
        return new PL(content, new Lookup[]{additional, inner});
    }

    public NodeStack.Frame getFrame() {
        return this.frame;
    }

    public Location getLocation() {
        return this.frame.getLocation();
    }

    public String getHtmlDisplayName() {
        String n = this.htmlNameSupplier.apply(this.getLocation());
        if (this.getLocation().isResolved()) {
            return n;
        }
        if (this.regListener == null) {
            this.regListener = new L();
            FileRegistry reg = FileRegistry.getInstance();
            this.wL = (FileRegistry.FileRegistryListener)WeakListeners.create(FileRegistry.FileRegistryListener.class, (EventListener)this.regListener, (Object)reg);
            reg.addFileRegistryListener(this.wL);
        }
        return Bundle.HtmlFormat_Unresolved(n);
    }

    private static class PL
    extends ProxyLookup
    implements InstanceContent.Convertor {
        InstanceContent content;

        public PL(InstanceContent content, Lookup[] lkps) {
            super(lkps);
            this.content = content;
        }

        public Object convert(Object t) {
            return new LocationOpener((Location)this.lookup(Location.class));
        }

        public Class type(Object t) {
            return (Class)t;
        }

        public String id(Object t) {
            return ((Class)t).getName();
        }

        public String displayName(Object t) {
            return this.id(t);
        }
    }

    class L
    implements FileRegistry.FileRegistryListener {
        L() {
        }

        @Override
        public void filesResolved(FileRegistry.FileRegistryEvent ev) {
            if (!ev.getResolvedKeys().contains(DefaultFrameNode.this.getLocation().getFile())) {
                return;
            }
            ev.getRegistry().removeFileRegistryListener(DefaultFrameNode.this.wL);
            DefaultFrameNode.this.fireDisplayNameChange(null, null);
        }
    }
}

