/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.ui;

import javax.swing.SwingUtilities;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.java.ui.Bundle;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.actions.Viewable;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public class LocationOpener
implements Openable,
Viewable {
    private final Location location;

    public LocationOpener(Location location) {
        this.location = location;
    }

    public void open() {
        this.openOrView(true);
    }

    private void openOrView(boolean focus) {
        FileObject toOpen = this.location.getOriginFile();
        if (toOpen == null) {
            return;
        }
        int line = this.location.getLine();
        EditorCookie cake = (EditorCookie)toOpen.getLookup().lookup(EditorCookie.class);
        if (cake == null) {
            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_CannotOpenFile(toOpen.getPath()));
            return;
        }
        if (line < 1) {
            cake.open();
            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_LineNotFound());
        } else {
            this.openAtLine(cake, line, focus);
        }
    }

    private void openAtLine(EditorCookie cake, int line, boolean focus) {
        Line l;
        try {
            l = cake.getLineSet().getOriginal(line - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        if (l == null) {
            cake.open();
            StatusDisplayer.getDefault().setStatusText(Bundle.ERR_LineNotFound());
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            l.show(Line.ShowOpenType.REUSE, focus ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FRONT);
        } else {
            SwingUtilities.invokeLater(() -> l.show(Line.ShowOpenType.REUSE, focus ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FRONT));
        }
    }

    public void view() {
        this.openOrView(false);
    }
}

