/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptException;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.filter.Bundle;
import org.graalvm.visualizer.filter.CachedLanguageFilter;
import org.graalvm.visualizer.filter.EditFilterDialog;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.script.PreparedScript;
import org.graalvm.visualizer.script.ScriptCancelledException;
import org.graalvm.visualizer.script.ScriptDefinition;
import org.graalvm.visualizer.script.UserScriptEngine;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class CustomFilter
extends AbstractFilter {
    private static final String PROPNAME_LANGUAGE = "language";
    private static final String PROPNAME_NAME = "name";
    public static final String MIME_JAVASCRIPT = "text/javascript";
    private static final String PARAM_GRAPH = "graph";
    private static final String PARAM_IO = "IO";
    private String mimeType;
    private String code;
    private String name;
    private CachedLanguageFilter cachedFilter;
    private static final List<String> parameters = Arrays.asList("IO", "graph");
    private final Map<FilterEnvironment, PreparedScript> executingScript = new HashMap<FilterEnvironment, PreparedScript>();

    public CustomFilter(String name, String code) {
        this(name, code, MIME_JAVASCRIPT, Lookup.EMPTY);
    }

    public CustomFilter(String name, String code, String mimeType, Lookup lkp) {
        super(lkp);
        this.name = name;
        this.code = code;
        this.mimeType = mimeType;
        this.getProperties().setProperty(PROPNAME_NAME, (Object)name);
        this.getProperties().setProperty(PROPNAME_LANGUAGE, (Object)mimeType);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String s) {
        if (Objects.equals(this.name, s)) {
            return;
        }
        this.name = s;
        this.fireChangedEvent();
    }

    public void setCode(String s) {
        if (Objects.equals(this.code, s)) {
            return;
        }
        this.code = s;
        this.cachedFilter = null;
        this.fireChangedEvent();
    }

    @Override
    public OpenCookie getEditor() {
        return this::openInEditor;
    }

    public boolean openInEditor() {
        EditFilterDialog dialog = new EditFilterDialog(this);
        dialog.setVisible(true);
        return dialog.wasAccepted();
    }

    public String toString() {
        return this.getName();
    }

    private String loadDefaultScripts() throws ScriptException {
        FileObject scriptFolder = FileUtil.getConfigFile((String)("ScriptingEnvironment/" + this.mimeType));
        if (scriptFolder == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (FileObject sf : FileUtil.getOrder(Arrays.asList(scriptFolder.getChildren()), (boolean)false)) {
            if (!this.mimeType.equals(sf.getMIMEType())) continue;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(sf.getInputStream()));){
                String s;
                while ((s = r.readLine()) != null) {
                    sb.append(s);
                    sb.append("\n");
                }
            }
            catch (IOException ex) {
                ScriptException scriptEx = new ScriptException(Bundle.ERR_LoadingEnvironmentScript(sf.getNameExt(), ex.toString()));
                scriptEx.initCause(ex);
                throw scriptEx;
            }
        }
        return sb.toString();
    }

    private PreparedScript executeHelpers(FilterEnvironment env, Map<String, Object> bindings, AtomicReference<UserScriptEngine> eng) throws ScriptException {
        String k = CustomFilter.class.getName() + "." + this.mimeType;
        H helpers = (H)env.getScriptEnvironment().getValue((Object)k);
        if (helpers != null && helpers.get() == env) {
            eng.set(helpers.prep.getEngine());
            return helpers.prep;
        }
        helpers = new H(env, this.executeHelperScripts(env, bindings, eng));
        env.getScriptEnvironment().setValue((Object)k, (Object)helpers);
        return null;
    }

    protected ScriptDefinition customizeScriptDefinition(ScriptDefinition base, boolean userCode) {
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalScript(FilterEnvironment e, PreparedScript p, Map<String, Object> parameters) throws ScriptException {
        Object object = this;
        synchronized (object) {
            if (FilterExecution.get().isCancelled()) {
                p.cancel();
            }
            this.executingScript.put(e, p);
        }
        try {
            object = p.evaluate(parameters);
            return object;
        }
        finally {
            CustomFilter customFilter = this;
            synchronized (customFilter) {
                this.executingScript.put(e, null);
            }
        }
    }

    private PreparedScript executeHelperScripts(FilterEnvironment env, Map<String, Object> bindings, AtomicReference<UserScriptEngine> eng) throws ScriptException {
        Collection engs = Lookup.getDefault().lookupAll(UserScriptEngine.class);
        ScriptException exception = null;
        for (UserScriptEngine e : engs) {
            if (!e.acceptsLanguage(this.mimeType)) continue;
            eng.set(e);
            String toCompile = this.loadDefaultScripts();
            try {
                ScriptDefinition def = new ScriptDefinition(this.mimeType).code(toCompile).filename(this.name).globals(bindings);
                def = this.customizeScriptDefinition(def, false);
                PreparedScript res = e.prepare(env.getScriptEnvironment(), def);
                this.evalScript(env, res, Collections.emptyMap());
                return res;
            }
            catch (ScriptException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyWith(FilterEnvironment env) {
        PreparedScript previous;
        if (this.cachedFilter != null) {
            this.cachedFilter.apply(env.getDiagram());
            return;
        }
        CustomFilter customFilter = this;
        synchronized (customFilter) {
            previous = this.executingScript.put(env, null);
        }
        try {
            this.applyWith0(env);
        }
        finally {
            customFilter = this;
            synchronized (customFilter) {
                if (previous != null) {
                    this.executingScript.put(env, previous);
                } else {
                    this.executingScript.remove(env);
                }
            }
        }
    }

    void applyWith0(FilterEnvironment env) {
        HashMap<String, Object> b = new HashMap<String, Object>();
        b.put(PARAM_GRAPH, env.getDiagram());
        b.put(PARAM_IO, System.out);
        for (String s : env.globals().keySet()) {
            b.put(s, env.globals().get(s));
        }
        try {
            AtomicReference<UserScriptEngine> eng = new AtomicReference<UserScriptEngine>();
            ScriptDefinition def = new ScriptDefinition(this.mimeType).code(this.getCode()).filename(this.name);
            this.customizeScriptDefinition(def, true);
            this.executeHelpers(env, b, eng);
            UserScriptEngine e = eng.get();
            PreparedScript prep = e.prepare(env.getScriptEnvironment(), def);
            if (prep == null) {
                throw new IllegalStateException(Bundle.ERR_CannotRunScript(this.name, this.mimeType));
            }
            Object result = this.evalScript(env, prep, b);
            if (result instanceof CachedLanguageFilter) {
                this.cachedFilter = (CachedLanguageFilter)result;
                this.cachedFilter.setName(this.name);
                this.cachedFilter.apply(env.getDiagram());
            }
        }
        catch (ScriptCancelledException ex) {
            throw new FilterCanceledException(env, ex.getCause());
        }
        catch (ScriptException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(FilterEnvironment d) {
        CustomFilter customFilter = this;
        synchronized (customFilter) {
            PreparedScript prep = this.executingScript.get(d);
            if (prep == null) {
                return true;
            }
            return prep.cancel();
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    private static class H
    extends WeakReference<FilterEnvironment> {
        final PreparedScript prep;

        public H(FilterEnvironment referent, PreparedScript prep) {
            super(referent);
            this.prep = prep;
        }
    }
}

