/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.connection;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.BinarySource;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.DataSource;
import jdk.graal.compiler.graphio.parsing.DocumentFactory;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import org.graalvm.visualizer.data.serialization.lazy.CachedContent;
import org.graalvm.visualizer.data.serialization.lazy.NetworkStreamContent;
import org.graalvm.visualizer.data.serialization.lazy.ScanningModelBuilder;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class Client
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Client.class.getName());
    private final SocketChannel socket;
    private final DocumentFactory rootDocumentFactory;
    private final RequestProcessor loader;
    private final ParseMonitor monitor;
    private static final AtomicInteger clientId = new AtomicInteger();

    public Client(SocketChannel socket, DocumentFactory rootDocumentFactory, ParseMonitor monitor, RequestProcessor loadProcessor) {
        this.socket = socket;
        this.rootDocumentFactory = rootDocumentFactory;
        this.loader = loadProcessor;
        this.monitor = monitor;
    }

    private void runInAWT(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int id = clientId.incrementAndGet();
        try {
            LOG.log(Level.FINE, "Client {0} starting for remote {1}", new Object[]{id, this.socket.getRemoteAddress()});
            SocketChannel channel = this.socket;
            channel.configureBlocking(true);
            try (NetworkStreamContent captureChannel = new NetworkStreamContent((ReadableByteChannel)channel, Places.getCacheSubdirectory((String)"igv"));){
                File docId = captureChannel.getDumpFile();
                BinarySource bs = new BinarySource((Object)docId, (ReadableByteChannel)captureChannel);
                ScanningModelBuilder mb = new ScanningModelBuilder(bs, (CachedContent)captureChannel, this.rootDocumentFactory, this.monitor, (ScheduledExecutorService)this.loader);
                mb.setDocumentId((Object)docId);
                BinaryReader reader = new BinaryReader((DataSource)bs, (Builder)mb);
                reader.parse();
            }
        }
        catch (EOFException ex) {
            LOG.log(Level.INFO, "Client {0} encountered end-of-file", id);
        }
        catch (IOException | RuntimeException ex) {
            LOG.log(Level.WARNING, "Error during processing the stream", Exceptions.attachSeverity((Throwable)ex, (Level)Level.INFO));
        }
        finally {
            try {
                this.socket.close();
                LOG.log(Level.FINE, "Client {0} terminated", id);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

