/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class ClassPathProviderImpl
implements ClassPathProvider {
    public static final String SOURCE_CP = "classpath/html5";
    private final ClientSideProject project;

    public ClassPathProviderImpl(ClientSideProject project) {
        this.project = project;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (SOURCE_CP.equals(type) && (ClientSideProjectUtilities.isParentOrItself(this.project.getSourcesFolder(), file) || ClientSideProjectUtilities.isParentOrItself(this.project.getSiteRootFolder(), file) || ClientSideProjectUtilities.isParentOrItself(this.project.getTestsFolder(false), file) || ClientSideProjectUtilities.isParentOrItself(this.project.getTestsSeleniumFolder(false), file))) {
            return this.project.getSourceClassPath();
        }
        return null;
    }

    public static ClassPath createProjectClasspath(PathResourceImplementation pathResourceImplementation) {
        assert (pathResourceImplementation != null);
        return ClassPathSupport.createClassPath(Collections.singletonList(pathResourceImplementation));
    }

    public static class PathImpl
    implements FilteringPathResourceImplementation {
        private final ClientSideProject project;
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);

        public PathImpl(ClientSideProject project) {
            this.project = project;
            this.project.getEvaluator().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("source.folder".equals(evt.getPropertyName()) || "site.root.folder".equals(evt.getPropertyName()) || "test.folder".equals(evt.getPropertyName()) || "test.selenium.folder".equals(evt.getPropertyName()) || evt.getPropertyName().startsWith("file.reference.")) {
                        this.fireRootsChanged();
                    }
                }
            });
        }

        public void fireRootsChanged() {
            this.support.firePropertyChange("roots", null, null);
        }

        public boolean includes(URL root, String resource) {
            return !resource.startsWith("nbproject");
        }

        public URL[] getRoots() {
            FileObject testsSeleniumFolder;
            ArrayList<URL> roots = new ArrayList<URL>();
            FileObject sourcesFolder = this.project.getSourcesFolder();
            FileObject siteRootFolder = this.project.getSiteRootFolder();
            boolean isSourcesParentOfSiteRoot = ClientSideProjectUtilities.isParentOrItself(sourcesFolder, siteRootFolder);
            boolean isSiteRootParentOfSources = ClientSideProjectUtilities.isParentOrItself(siteRootFolder, sourcesFolder);
            if (isSourcesParentOfSiteRoot && isSiteRootParentOfSources) {
                assert (sourcesFolder != null);
                assert (sourcesFolder.equals(siteRootFolder)) : sourcesFolder + " should equal to " + siteRootFolder;
                roots.add(sourcesFolder.toURL());
            } else if (isSourcesParentOfSiteRoot) {
                assert (sourcesFolder != null);
                roots.add(sourcesFolder.toURL());
            } else if (isSiteRootParentOfSources) {
                assert (siteRootFolder != null);
                roots.add(siteRootFolder.toURL());
            } else {
                if (sourcesFolder != null) {
                    roots.add(sourcesFolder.toURL());
                }
                if (siteRootFolder != null) {
                    roots.add(siteRootFolder.toURL());
                }
            }
            FileObject testsFolder = this.project.getTestsFolder(false);
            if (testsFolder != null && !ClientSideProjectUtilities.isParentOrItself(sourcesFolder, testsFolder) && !ClientSideProjectUtilities.isParentOrItself(siteRootFolder, testsFolder)) {
                roots.add(testsFolder.toURL());
            }
            if ((testsSeleniumFolder = this.project.getTestsSeleniumFolder(false)) != null && !ClientSideProjectUtilities.isParentOrItself(sourcesFolder, testsSeleniumFolder) && !ClientSideProjectUtilities.isParentOrItself(siteRootFolder, testsSeleniumFolder)) {
                roots.add(testsSeleniumFolder.toURL());
            }
            for (PlatformProvider provider : this.project.getPlatformProviders()) {
                roots.addAll(provider.getSourceRoots((Project)this.project));
            }
            return roots.toArray(new URL[0]);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }
    }
}

