/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.graalvm.visualizer.filterwindow.impl.FilterProfileNode;
import org.graalvm.visualizer.util.swing.DropdownButton;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class LinkExistingFilter
extends AbstractAction
implements Presenter.Toolbar,
Presenter.Menu,
ContextAwareAction,
PropertyChangeListener {
    public static final String ID_CATEGORY = "Filters";
    public static final String ID_LINK_EXISTING_FILTER = "org.graalvm.visualizer.filterwindow.actions.LinkExistingFilter";
    private static final String ICON_ADD_EXISTING = "org/graalvm/visualizer/filterwindow/images/addExistingFilter.png";
    private DropdownButton popButton;
    private final Lookup context;
    private final ProfileService profileService;
    private final Lookup.Result<FilterProfile> profileResult;
    private FilterProfile target;
    private List<Filter> filterList;
    private PropertyChangeListener weakPL;

    public LinkExistingFilter() {
        this(Lookup.getDefault());
    }

    private LinkExistingFilter(Lookup context) {
        this((FilterProfile)context.lookup(FilterProfile.class), (ProfileService)Lookup.getDefault().lookup(ProfileService.class), context);
    }

    private LinkExistingFilter(FilterProfile target, ProfileService profileService, Lookup context) {
        super(Bundle.ACTION_LinkExistingFilter());
        this.context = context;
        this.target = target;
        this.profileService = profileService;
        this.profileResult = context.lookupResult(FilterProfile.class);
        this.profileResult.addLookupListener(this::lookupChanged);
        this.updateFilterProfileAndList();
    }

    void setTarget(FilterProfile target) {
        if (this.target == target) {
            return;
        }
        if (this.target != null && this.weakPL != null) {
            this.target.removePropertyChangeListener(this.weakPL);
        }
        this.target = target;
        if (target == null) {
            return;
        }
        this.weakPL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)target);
        target.addPropertyChangeListener(this.weakPL);
    }

    void updateFilterProfileAndList() {
        FilterProfile prof = (FilterProfile)this.context.lookup(FilterProfile.class);
        this.setTarget(prof);
        if (prof == null) {
            this.filterList = Collections.emptyList();
            this.setEnabled(false);
            return;
        }
        HashSet<Filter> presentDefFilters = new HashSet<Filter>();
        for (Filter tf : this.target.getProfileFilters()) {
            Filter df = this.profileService.findDefaultFilter(tf);
            presentDefFilters.add(df);
        }
        ArrayList<Filter> allDefFilters = new ArrayList<Filter>(this.profileService.getDefaultProfile().getProfileFilters());
        allDefFilters.removeAll(presentDefFilters);
        this.filterList = allDefFilters;
        this.setEnabled(!this.filterList.isEmpty());
        if (this.popButton != null) {
            this.popButton.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "profileFilters".equals(evt.getPropertyName())) {
            this.updateFilterProfileAndList();
        }
    }

    void lookupChanged(LookupEvent e) {
        SwingUtilities.invokeLater(this::updateFilterProfileAndList);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Component getToolbarPresenter() {
        if (this.popButton != null) {
            return this.popButton;
        }
        DropdownButton button = new DropdownButton("", (Icon)ImageUtilities.loadImageIcon((String)ICON_ADD_EXISTING, (boolean)false), true, this::populateMenu, (ActionListener)this);
        button.setPopupEnabled(true);
        button.setEnabled(this.isEnabled());
        button.setToolTipText(Bundle.ACTION_LinkExistingFilter());
        this.popButton = button;
        return this.popButton;
    }

    private void populateMenu(JPopupMenu menu) {
        if (this.target == null) {
            return;
        }
        Node orig = FilterProfileNode.create(this.profileService.getDefaultProfile());
        Node[] origCh = orig.getChildren().getNodes(true);
        menu.add(Actions.forID((String)ID_CATEGORY, (String)"org.graalvm.visualizer.filterwindow.actions.NewFilterAction"));
        for (Node n : origCh) {
            Filter f = (Filter)n.getLookup().lookup(Filter.class);
            if (!this.filterList.contains(f)) continue;
            menu.add(new AddOneFilterAction(this.target, n.cloneNode()));
        }
    }

    public Action createContextAwareInstance(Lookup lkp) {
        return new LinkExistingFilter(lkp);
    }

    public JMenuItem getMenuPresenter() {
        return null;
    }

    private static class AddOneFilterAction
    extends AbstractAction {
        private final Node filterDelegate;
        private final FilterProfile profile;

        AddOneFilterAction(FilterProfile profile, Node filterDelegate) {
            super(filterDelegate.getDisplayName(), ImageUtilities.image2Icon((Image)filterDelegate.getIcon(1)));
            this.filterDelegate = filterDelegate;
            this.profile = profile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.profile.addSharedFilter((Filter)this.filterDelegate.getLookup().lookup(Filter.class));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

