/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class MoveFilterAction
extends AbstractAction {
    public static final String ID_MOVE_DOWN = "org.graalvm.visualizer.filterwindow.actions.MoveDown";
    public static final String ID_MOVE_UP = "org.graalvm.visualizer.filterwindow.actions.MoveUp";
    public static final String CATEGORY = "Filters";
    private final boolean direction;
    private final List<Filter> filters;

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterProfile ops = this.findOperations();
        if (ops == null) {
            return;
        }
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        ArrayList profFilters = new ArrayList(ops.getProfileFilters());
        profFilters.retainAll(this.filters);
        if (this.direction) {
            Collections.reverse(profFilters);
        }
        for (Filter c : profFilters) {
            if (c == null) continue;
            try {
                if (this.direction) {
                    ops.moveDown(c);
                    continue;
                }
                ops.moveUp(c);
            }
            catch (IOException ex) {
                exceptions.add(ex);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.FILTER_MoveFailed1(((IOException)exceptions.get(0)).toString()), 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
    }

    public MoveFilterAction(List<Filter> filters, boolean direction) {
        this.direction = direction;
        this.filters = filters;
    }

    private FilterProfile findOperations() {
        FilterProfile ops = null;
        for (Filter f : this.filters) {
            FilterProfile test = (FilterProfile)f.getLookup().lookup(FilterProfile.class);
            if (test == null) continue;
            if (ops != null && ops != test) {
                return null;
            }
            ops = test;
        }
        return ops;
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        FilterProfile ops = this.findOperations();
        if (ops == null) {
            return false;
        }
        List seq = ops.getProfileFilters();
        for (Filter f : this.filters) {
            if (f == null || !(this.direction ? seq.indexOf(f) >= seq.size() - 1 : seq.indexOf(f) == 0)) continue;
            return false;
        }
        return true;
    }

    public static class Up
    extends MoveFilterAction {
        public Up(List<Filter> context) {
            super(context, false);
        }
    }

    public static class Down
    extends MoveFilterAction {
        public Down(List<Filter> context) {
            super(context, true);
        }
    }
}

