/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public final class RemoveFilterAction
extends AbstractAction {
    public static final String CATEGORY = "Filters";
    public static final String ID = "org.graalvm.visualizer.filterwindow.actions.RemoveFilterAction";
    private final List<Filter> filters;
    private final ProfileService profileService;
    private FilterProfile parentProfile;

    public RemoveFilterAction(List<Filter> filters) {
        this.filters = new ArrayList<Filter>(filters);
        this.profileService = (ProfileService)Lookup.getDefault().lookup(ProfileService.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.profileService == null) {
            return;
        }
        FilterProfile candidate = null;
        for (Filter f : this.filters) {
            FilterProfile parent = (FilterProfile)f.getLookup().lookup(FilterProfile.class);
            if (candidate == null) {
                candidate = parent;
                continue;
            }
            if (candidate == parent) continue;
            candidate = null;
            break;
        }
        if (candidate == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.parentProfile = candidate;
        this.filters.retainAll(this.parentProfile.getProfileFilters());
        boolean warn = true;
        if (this.parentProfile == this.profileService.getDefaultProfile()) {
            HashSet allLocations = new HashSet();
            HashSet profileNames = new HashSet();
            for (Filter filter : this.filters) {
                Set locations = this.profileService.findLocations(filter);
                allLocations.addAll(locations);
            }
            allLocations.stream().map(FilterProfile::getName).sorted().forEach(profileNames::add);
            if (!profileNames.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String s : profileNames) {
                    sb.append(Bundle.CONFIRM_FilterIsUsedListItem(s));
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)Bundle.CONFIRM_FilterIsUsed(sb.toString()), Bundle.TITLE_ConfirmRemoveFilterIsUsed(), 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                String pname = "";
                try {
                    for (FilterProfile p : allLocations) {
                        pname = p.getName();
                        for (Filter f : this.filters) {
                            this.profileService.deleteFromAllProfiles(f);
                        }
                    }
                }
                catch (IOException ex) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.ERR_ErrorDeletingAssociatedFilter(pname, ex.toString()), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                }
                warn = false;
            }
        }
        if (warn) {
            NotifyDescriptor.Confirmation conf = this.filters.size() == 1 ? new NotifyDescriptor.Confirmation((Object)Bundle.CONFIRM_FilterRemove1(this.filters.get(0).getName()), Bundle.TITLE_RemoveFilterConfirmation1(), 0) : new NotifyDescriptor.Confirmation((Object)Bundle.CONFIRM_FilterRemove2(this.filters.size()), Bundle.TITLE_RemoveFilterConfirmation1(), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)conf) != NotifyDescriptor.YES_OPTION) {
                return;
            }
            String fname = "";
            try {
                for (Filter filter : this.filters) {
                    fname = filter.getName();
                    this.profileService.deleteFilter(filter);
                }
            }
            catch (IOException ex) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.ERR_ErrorDeletingFilter(fname, ex.toString()), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            }
        }
    }
}

