/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class RemoveProfileAction
extends AbstractAction {
    public static final String CATEGORY = "Filters";
    public static final String ID = "org.graalvm.visualizer.filterwindow.actions.RemoveProfileAction";
    private final ProfileService profileService;
    private final FilterProfile profile;

    public RemoveProfileAction(FilterProfile profile) {
        this.profile = profile;
        this.profileService = (ProfileService)Lookup.getDefault().lookup(ProfileService.class);
    }

    @Override
    public boolean isEnabled() {
        return this.profile != this.profileService.getDefaultProfile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NotifyDescriptor.Confirmation conf = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_RemoveProfileConfirm(this.profile.getName()), Bundle.TITLE_RemoveProfile(), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)conf) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        try {
            this.profileService.deleteProfile(this.profile);
        }
        catch (IOException ex) {
            NotifyDescriptor.Message err = new NotifyDescriptor.Message((Object)Bundle.ERR_CannotDeleteProfile(ex.toString()), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)err);
        }
    }
}

