/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class RenameFilterAction
extends AbstractAction {
    public static final String CATEGORY = "Filters";
    public static final String ID = "org.graalvm.visualizer.filterwindow.actions.RenameFilterAction";
    private final Filter filter;
    private final ProfileService service;

    public RenameFilterAction(Filter filter) {
        this(filter, (ProfileService)Lookup.getDefault().lookup(ProfileService.class));
    }

    RenameFilterAction(Filter filter, ProfileService service) {
        this.filter = filter;
        this.service = service;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(Bundle.LABEL_RenameFilter(), Bundle.TITLE_RenameFilter());
        try {
            il.setInputText(this.filter.getName());
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)il) != DialogDescriptor.OK_OPTION) {
                return;
            }
            this.doRenameFilter(il.getInputText().trim());
        }
        catch (IOException ex) {
            NotifyDescriptor.Message err = new NotifyDescriptor.Message((Object)Bundle.ERROR_CouldNotRenameFilter(il.getInputText(), ex.toString()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)err);
        }
    }

    void doRenameFilter(String newName) throws IOException {
        Filter orig = this.service.findDefaultFilter(this.filter);
        if (orig != null && orig != this.filter && orig.getName().equals(this.filter.getName())) {
            this.service.renameFilter(orig, newName);
        }
        this.service.renameFilter(this.filter, newName);
    }
}

