/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.settings.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.graalvm.visualizer.settings.Settings;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.settings.ui.LayoutOptionsPanelController;
import org.graalvm.visualizer.settings.ui.SettingsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class LayoutPanel
extends SettingsPanel<LayoutPanel, LayoutOptionsPanelController> {
    private final LayoutSettings.LayoutSettingBean setting;
    private final List<Runnable> bases = new ArrayList<Runnable>();
    private JButton advancedAsDefaultButton;
    private JRadioButton advancedRadioB;
    private JCheckBox assignDuringCrossingCheckBox;
    private JCheckBox blockViewAsControlFlowCheckBox;
    private JCheckBox bothSortCheckBox;
    private JCheckBox centerCrossingCheckBox;
    private JCheckBox centerSimpleNodesCheckBox;
    private JFormattedTextField crossFactorFormattedTextField;
    private JCheckBox crossingByConnDiffCheckBox;
    private JPanel crossingPanel;
    private JCheckBox crossingReductionDuringRoutingCheckBox;
    private ButtonGroup crossingResetGroup;
    private JCheckBox crossingResetXFromNodeCheckBox;
    private JRadioButton crossingResetXLeftRadioButton;
    private JRadioButton crossingResetXMiddleRadioButton;
    private JScrollPane crossingScrollPane;
    private JCheckBox crossingSortCheckBox;
    private JComboBox<String> crossingSweepCountComboBox;
    private JRadioButton decreaseDeviationDownRadioButton;
    private ButtonGroup decreaseDeviationGroup;
    private JRadioButton decreaseDeviationUpRadioButton;
    private JCheckBox decreaseLayerWidthDeviationCheckBox;
    private JCheckBox decreaseLayerWidthDeviationQuickCheckBox;
    private ButtonGroup defaultLayoutGroup;
    private JRadioButton defaultRadioB;
    private JCheckBox delayDanglingNodesCheckBox;
    private JCheckBox dummyCrossingCheckBox;
    private JCheckBox dummyFirstSortCheckBox;
    private JPanel dummyPanel;
    private JScrollPane dummyScrollPane;
    private JFormattedTextField dummyWidthFormattedTextField;
    private JLabel dummyWidthLabel;
    private JCheckBox edgeBendingCheckBox;
    private JPanel generalPanel;
    private JScrollPane generalScrollPane;
    private JCheckBox irrelevantCodeCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollBar jScrollBar1;
    private JCheckBox lastDownSweepCheckBox;
    private JCheckBox lastUpCrossingSweepCheckBox;
    private JPanel layeringPanel;
    private JScrollPane layeringScrollPane;
    private JCheckBox longEdgesCheckBox;
    private JFormattedTextField maxBlockLayerLengthFormattedTextField;
    private JFormattedTextField maxLayerLengthFormattedTextField;
    private JCheckBox meanCheckBox;
    private JFormattedTextField minEdgeAngleFormattedTextField;
    private JCheckBox noCrossingLayerReassignCheckBox;
    private JCheckBox noLongDummyCheckBox;
    private JCheckBox noVIPCheckBox;
    private JTextField nodeNameTextField;
    private JCheckBox optimalUpVIPCheckBox;
    private JComboBox<String> presetComboBox;
    private JLabel presetLabel;
    private JCheckBox previewCheckBox;
    private JCheckBox properCrossingClosestNodeCheckBox;
    private JButton resetAdvancedButton;
    private JCheckBox reverseSortCheckBox;
    private JPanel routingPanel;
    private JScrollPane routingScrollPane;
    private JTabbedPane settingsPane;
    private JCheckBox spanByAngleCheckBox;
    private JCheckBox squashNodesCheckBox;
    private JCheckBox stabilizedLayoutCheckBox;
    private JCheckBox standAlonesCheckBox;
    private JComboBox<String> sweepCountComboBox;
    private JLabel sweepCountLabel;
    private JCheckBox unknownCrossingNumberChangeCheckBox;
    private JCheckBox unreverseVIPsCheckBox;
    private JCheckBox useCrossFactorCheckBox;
    private JPanel writePanel;
    private JScrollPane writeScrollPane;
    private JPanel xAssignPanel;
    private JScrollPane xAssignScrollPane;
    private JPanel yAsignPanel;
    private JScrollPane yAssignScrollPane;

    LayoutPanel(LayoutOptionsPanelController controller) {
        super(controller);
        this.setting = LayoutSettings.getBean();
        this.initComponents();
        LayoutPanel.group(this.defaultLayoutGroup, this.defaultRadioB, this.advancedRadioB);
        LayoutPanel.group(this.crossingResetGroup, this.crossingResetXLeftRadioButton, this.crossingResetXMiddleRadioButton);
        LayoutPanel.group(this.decreaseDeviationGroup, this.decreaseDeviationUpRadioButton, this.decreaseDeviationDownRadioButton);
        LayoutPanel.setMin(this.dummyWidthFormattedTextField, Integer.valueOf(1));
        LayoutPanel.setMin(this.minEdgeAngleFormattedTextField, Integer.valueOf(1));
        LayoutPanel.setMax(this.minEdgeAngleFormattedTextField, Integer.valueOf(89));
        LayoutPanel.setMin(this.maxLayerLengthFormattedTextField, Integer.valueOf(3));
        LayoutPanel.setMin(this.maxBlockLayerLengthFormattedTextField, Integer.valueOf(3));
        LayoutPanel.setMin(this.crossFactorFormattedTextField, Integer.valueOf(0));
        this.tieComponentsToProperties();
        SwingUtilities.invokeLater(() -> LayoutPanel.setPreferredSizeRecursive(this.getParent()));
    }

    private void tieComponentsToProperties() {
        this.tie(BOOL, this.lastDownSweepCheckBox, "LAST_DOWN_SWEEP", false);
        this.tie(BOOL, this.squashNodesCheckBox, "SQUASH_POSITION", false);
        this.tie(BOOL, this.defaultRadioB, "DEFAULT_LAYOUT");
        this.tie(NOT, this.advancedRadioB, "DEFAULT_LAYOUT");
        this.disables(this.defaultRadioB, this.settingsPane);
        this.enables(this.advancedRadioB, this.settingsPane);
        this.tie(BOOL, this.previewCheckBox, "ACTIVE_PREVIEW");
        this.tie(BOOL, this.longEdgesCheckBox, "DRAW_LONG_EDGES");
        this.tie(BOOL, this.noCrossingLayerReassignCheckBox, "NO_CROSSING_LAYER_REASSIGN", false);
        this.tie(BOOL, this.crossingSortCheckBox, "CROSSING_SORT", false);
        this.tie(BOOL, this.centerCrossingCheckBox, "CENTER_CROSSING_X", false);
        this.tie(BOOL, this.irrelevantCodeCheckBox, "IRRELEVANT_LAYOUT_CODE");
        this.tie(BOOL, this.lastUpCrossingSweepCheckBox, "LAST_UP_CROSSING_SWEEP", false);
        this.tie(BOOL, this.properCrossingClosestNodeCheckBox, "PROPER_CROSSING_CLOSEST_NODE", false);
        this.tie(BOOL, this.unknownCrossingNumberChangeCheckBox, "UNKNOWN_CROSSING_NUMBER", false);
        this.tie(INT_COMB, this.sweepCountComboBox, "X_ASSIGN_SWEEP_COUNT", 1);
        this.tie(BOOL, this.noLongDummyCheckBox, "NO_DUMMY_LONG_EDGES", false);
        this.tie(BOOL, this.reverseSortCheckBox, "REVERSE_SORT", false);
        this.tie(BOOL, this.bothSortCheckBox, "BOTH_SORT", false);
        this.tie(BOOL, this.meanCheckBox, "MEAN_MEDIAN", false);
        this.tie(BOOL, this.optimalUpVIPCheckBox, "OPTIMAL_UP_VIP", false);
        this.tie(BOOL, this.noVIPCheckBox, "NO_VIP", false);
        this.tie(BOOL, this.edgeBendingCheckBox, "EDGE_BENDING", false);
        this.tie(BOOL, this.dummyFirstSortCheckBox, "DUMMY_FIRST_SORT", true);
        this.tie(BOOL, this.stabilizedLayoutCheckBox, "STABILIZED_LAYOUT", false);
        this.tie(INT_FORM, this.dummyWidthFormattedTextField, "DUMMY_WIDTH", 1);
        this.tie(BOOL, this.spanByAngleCheckBox, "SPAN_BY_ANGLE", false);
        this.tie(INT_FORM, this.minEdgeAngleFormattedTextField, "MIN_EDGE_ANGLE", 2);
        this.enables(this.spanByAngleCheckBox, this.minEdgeAngleFormattedTextField);
        this.tie(INT_COMB, this.crossingSweepCountComboBox, "CROSSING_SWEEP_COUNT", 2);
        this.tie(BOOL, this.dummyCrossingCheckBox, "DUMMY_CROSSING", false);
        this.tie(STRING, this.nodeNameTextField, "NODE_TEXT");
        this.tie(BOOL, this.unreverseVIPsCheckBox, "UNREVERSE_VIPS", false);
        this.tie(INT_FORM, this.maxLayerLengthFormattedTextField, "MAX_LAYER_LENGTH", 10);
        this.tie(INT_FORM, this.maxBlockLayerLengthFormattedTextField, "MAX_BLOCK_LAYER_LENGTH", 3);
        this.tie(BOOL, this.centerSimpleNodesCheckBox, "CENTER_SIMPLE_NODES", false);
        this.tie(BOOL, this.crossingByConnDiffCheckBox, "CROSS_BY_CONN_DIFF", false);
        this.tie(BOOL, this.crossingResetXFromNodeCheckBox, "CROSS_RESET_X_FROM_NODE", false);
        this.tie(BOOL, this.crossingResetXMiddleRadioButton, "CROSS_RESET_X_FROM_MIDDLE");
        this.tie(NOT, this.crossingResetXLeftRadioButton, "CROSS_RESET_X_FROM_MIDDLE");
        this.enables(this.crossingResetXFromNodeCheckBox, this.crossingResetXMiddleRadioButton);
        this.enables(this.crossingResetXFromNodeCheckBox, this.crossingResetXLeftRadioButton);
        this.tie(BOOL, this.useCrossFactorCheckBox, "CROSS_USE_FACTOR", false);
        this.tie(FLOAT, this.crossFactorFormattedTextField, "CROSS_FACTOR");
        this.enables(this.useCrossFactorCheckBox, this.crossFactorFormattedTextField);
        this.tie(BOOL, this.assignDuringCrossingCheckBox, "CROSS_POSITION_DURING", false);
        this.tie(BOOL, this.delayDanglingNodesCheckBox, "DELAY_DANGLING_NODES", false);
        this.tie(BOOL, this.decreaseLayerWidthDeviationCheckBox, "DECREASE_LAYER_WIDTH_DEVIATION", false);
        this.tie(BOOL, this.decreaseDeviationUpRadioButton, "DECREASE_LAYER_WIDTH_DEVIATION_UP");
        this.tie(NOT, this.decreaseDeviationDownRadioButton, "DECREASE_LAYER_WIDTH_DEVIATION_UP");
        this.tie(BOOL, this.decreaseLayerWidthDeviationQuickCheckBox, "DECREASE_LAYER_WIDTH_DEVIATION");
        this.enables(this.decreaseLayerWidthDeviationCheckBox, this.decreaseDeviationUpRadioButton);
        this.enables(this.decreaseLayerWidthDeviationCheckBox, this.decreaseDeviationDownRadioButton);
        this.enables(this.decreaseLayerWidthDeviationCheckBox, this.decreaseLayerWidthDeviationQuickCheckBox);
        this.tie(BOOL, this.crossingReductionDuringRoutingCheckBox, "CROSS_REDUCE_ROUTING", false);
        this.tie(BOOL, this.blockViewAsControlFlowCheckBox, "BLOCKVIEW_AS_CONTROLFLOW", false);
        this.tie(BOOL, this.standAlonesCheckBox, "STANDALONES", false);
    }

    private <T, C extends JComponent> void tie(SettingsPanel.Connector<T, C> type, C comp, String name, T base) {
        this.tie(type, comp, name);
        this.bases.add(() -> this.setting.set(name, base));
    }

    @Override
    protected Settings getSettings() {
        return this.setting;
    }

    @Override
    protected boolean isFireChanged() {
        return (Boolean)this.setting.get(Boolean.class, "ACTIVE_PREVIEW");
    }

    private void initComponents() {
        this.defaultLayoutGroup = new ButtonGroup();
        this.crossingResetGroup = new ButtonGroup();
        this.decreaseDeviationGroup = new ButtonGroup();
        this.jScrollBar1 = new JScrollBar();
        this.settingsPane = new JTabbedPane();
        this.routingScrollPane = new JScrollPane();
        this.routingPanel = new JPanel();
        this.crossingReductionDuringRoutingCheckBox = new JCheckBox();
        this.layeringScrollPane = new JScrollPane();
        this.layeringPanel = new JPanel();
        this.unreverseVIPsCheckBox = new JCheckBox();
        this.maxLayerLengthFormattedTextField = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.maxBlockLayerLengthFormattedTextField = new JFormattedTextField();
        this.jLabel5 = new JLabel();
        this.decreaseLayerWidthDeviationCheckBox = new JCheckBox();
        this.decreaseDeviationUpRadioButton = new JRadioButton();
        this.decreaseDeviationDownRadioButton = new JRadioButton();
        this.decreaseLayerWidthDeviationQuickCheckBox = new JCheckBox();
        this.dummyScrollPane = new JScrollPane();
        this.dummyPanel = new JPanel();
        this.noLongDummyCheckBox = new JCheckBox();
        this.dummyWidthFormattedTextField = new JFormattedTextField();
        this.dummyWidthLabel = new JLabel();
        this.crossingScrollPane = new JScrollPane();
        this.crossingPanel = new JPanel();
        this.noCrossingLayerReassignCheckBox = new JCheckBox();
        this.crossingSortCheckBox = new JCheckBox();
        this.centerCrossingCheckBox = new JCheckBox();
        this.lastUpCrossingSweepCheckBox = new JCheckBox();
        this.properCrossingClosestNodeCheckBox = new JCheckBox();
        this.unknownCrossingNumberChangeCheckBox = new JCheckBox();
        this.dummyCrossingCheckBox = new JCheckBox();
        this.crossingSweepCountComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.crossingByConnDiffCheckBox = new JCheckBox();
        this.crossingResetXFromNodeCheckBox = new JCheckBox();
        this.crossingResetXMiddleRadioButton = new JRadioButton();
        this.crossingResetXLeftRadioButton = new JRadioButton();
        this.useCrossFactorCheckBox = new JCheckBox();
        this.crossFactorFormattedTextField = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.assignDuringCrossingCheckBox = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.xAssignScrollPane = new JScrollPane();
        this.xAssignPanel = new JPanel();
        this.sweepCountComboBox = new JComboBox();
        this.sweepCountLabel = new JLabel();
        this.lastDownSweepCheckBox = new JCheckBox();
        this.squashNodesCheckBox = new JCheckBox();
        this.reverseSortCheckBox = new JCheckBox();
        this.bothSortCheckBox = new JCheckBox();
        this.meanCheckBox = new JCheckBox();
        this.optimalUpVIPCheckBox = new JCheckBox();
        this.dummyFirstSortCheckBox = new JCheckBox();
        this.centerSimpleNodesCheckBox = new JCheckBox();
        this.delayDanglingNodesCheckBox = new JCheckBox();
        this.yAssignScrollPane = new JScrollPane();
        this.yAsignPanel = new JPanel();
        this.spanByAngleCheckBox = new JCheckBox();
        this.minEdgeAngleFormattedTextField = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.writeScrollPane = new JScrollPane();
        this.writePanel = new JPanel();
        this.previewCheckBox = new JCheckBox();
        this.defaultRadioB = new JRadioButton();
        this.advancedRadioB = new JRadioButton();
        this.presetComboBox = new JComboBox();
        this.presetLabel = new JLabel();
        this.generalScrollPane = new JScrollPane();
        this.generalPanel = new JPanel();
        this.resetAdvancedButton = new JButton();
        this.advancedAsDefaultButton = new JButton();
        this.longEdgesCheckBox = new JCheckBox();
        this.irrelevantCodeCheckBox = new JCheckBox();
        this.noVIPCheckBox = new JCheckBox();
        this.edgeBendingCheckBox = new JCheckBox();
        this.stabilizedLayoutCheckBox = new JCheckBox();
        this.nodeNameTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.blockViewAsControlFlowCheckBox = new JCheckBox();
        this.standAlonesCheckBox = new JCheckBox();
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(500, 601));
        this.settingsPane.setMinimumSize(new Dimension(100, 250));
        this.routingPanel.setPreferredSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.crossingReductionDuringRoutingCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingReductionDuringRoutingCheckBox.text"));
        GroupLayout routingPanelLayout = new GroupLayout(this.routingPanel);
        this.routingPanel.setLayout(routingPanelLayout);
        routingPanelLayout.setHorizontalGroup(routingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(routingPanelLayout.createSequentialGroup().addComponent(this.crossingReductionDuringRoutingCheckBox).addGap(0, 0, Short.MAX_VALUE)));
        routingPanelLayout.setVerticalGroup(routingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(routingPanelLayout.createSequentialGroup().addComponent(this.crossingReductionDuringRoutingCheckBox).addGap(0, 0, Short.MAX_VALUE)));
        this.routingScrollPane.setViewportView(this.routingPanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.routingScrollPane.TabConstraints.tabTitle"), this.routingScrollPane);
        this.layeringPanel.setPreferredSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.unreverseVIPsCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.unreverseVIPsCheckBox.text"));
        this.maxLayerLengthFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.maxLayerLengthFormattedTextField.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.maxLayerLengthFormattedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel4.text"));
        this.maxBlockLayerLengthFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.maxBlockLayerLengthFormattedTextField.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.maxBlockLayerLengthFormattedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.decreaseLayerWidthDeviationCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.decreaseLayerWidthDeviationCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.decreaseDeviationUpRadioButton, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.decreaseDeviationUpRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.decreaseDeviationDownRadioButton, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.decreaseDeviationDownRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.decreaseLayerWidthDeviationQuickCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.decreaseLayerWidthDeviationQuickCheckBox.text"));
        GroupLayout layeringPanelLayout = new GroupLayout(this.layeringPanel);
        this.layeringPanel.setLayout(layeringPanelLayout);
        layeringPanelLayout.setHorizontalGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layeringPanelLayout.createSequentialGroup().addGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unreverseVIPsCheckBox).addGroup(layeringPanelLayout.createSequentialGroup().addGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.maxBlockLayerLengthFormattedTextField, GroupLayout.Alignment.LEADING).addComponent(this.maxLayerLengthFormattedTextField, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 284, -2).addComponent(this.jLabel5))).addComponent(this.decreaseLayerWidthDeviationCheckBox).addGroup(layeringPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.decreaseDeviationUpRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decreaseDeviationDownRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decreaseLayerWidthDeviationQuickCheckBox))).addGap(0, 0, Short.MAX_VALUE)));
        layeringPanelLayout.setVerticalGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layeringPanelLayout.createSequentialGroup().addComponent(this.unreverseVIPsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxLayerLengthFormattedTextField, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxBlockLayerLengthFormattedTextField, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decreaseLayerWidthDeviationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layeringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decreaseDeviationUpRadioButton).addComponent(this.decreaseDeviationDownRadioButton).addComponent(this.decreaseLayerWidthDeviationQuickCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        this.layeringScrollPane.setViewportView(this.layeringPanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.layeringScrollPane.TabConstraints.tabTitle"), this.layeringScrollPane);
        this.dummyPanel.setPreferredSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.noLongDummyCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.noLongDummyCheckBox.text"));
        this.dummyWidthFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.dummyWidthFormattedTextField.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.dummyWidthLabel, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.dummyWidthLabel.text"));
        GroupLayout dummyPanelLayout = new GroupLayout(this.dummyPanel);
        this.dummyPanel.setLayout(dummyPanelLayout);
        dummyPanelLayout.setHorizontalGroup(dummyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dummyPanelLayout.createSequentialGroup().addGroup(dummyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noLongDummyCheckBox).addGroup(dummyPanelLayout.createSequentialGroup().addComponent(this.dummyWidthFormattedTextField, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyWidthLabel))).addGap(0, 0, Short.MAX_VALUE)));
        dummyPanelLayout.setVerticalGroup(dummyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dummyPanelLayout.createSequentialGroup().addComponent(this.noLongDummyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dummyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dummyWidthFormattedTextField, -2, -1, -2).addComponent(this.dummyWidthLabel)).addGap(0, 0, Short.MAX_VALUE)));
        this.dummyScrollPane.setViewportView(this.dummyPanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.dummyScrollPane.TabConstraints.tabTitle"), this.dummyScrollPane);
        this.crossingScrollPane.setMinimumSize(new Dimension(100, 100));
        this.crossingScrollPane.setViewportView(this.crossingPanel);
        this.crossingPanel.setMinimumSize(new Dimension(100, 100));
        this.crossingPanel.setPreferredSize(new Dimension(100, 100));
        Mnemonics.setLocalizedText((AbstractButton)this.noCrossingLayerReassignCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.noCrossingLayerReassignCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.crossingSortCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingSortCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.centerCrossingCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.centerCrossingCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.lastUpCrossingSweepCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.lastUpCrossingSweepCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.properCrossingClosestNodeCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.properCrossingClosestNodeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.unknownCrossingNumberChangeCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.unknownCrossingNumberChangeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.dummyCrossingCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.dummyCrossingCheckBox.text"));
        this.crossingSweepCountComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.crossingByConnDiffCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingByConnDiffCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.crossingResetXFromNodeCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingResetXFromNodeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.crossingResetXMiddleRadioButton, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingResetXMiddleRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.crossingResetXLeftRadioButton, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingResetXLeftRadioButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useCrossFactorCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.useCrossFactorCheckBox.text"));
        this.crossFactorFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00"))));
        this.crossFactorFormattedTextField.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossFactorFormattedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.assignDuringCrossingCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.assignDuringCrossingCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel7.text"));
        GroupLayout crossingPanelLayout = new GroupLayout(this.crossingPanel);
        this.crossingPanel.setLayout(crossingPanelLayout);
        crossingPanelLayout.setHorizontalGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossingPanelLayout.createSequentialGroup().addGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossingPanelLayout.createSequentialGroup().addComponent(this.crossingSweepCountComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addComponent(this.crossingSortCheckBox).addComponent(this.centerCrossingCheckBox).addComponent(this.lastUpCrossingSweepCheckBox).addComponent(this.properCrossingClosestNodeCheckBox).addComponent(this.unknownCrossingNumberChangeCheckBox).addComponent(this.dummyCrossingCheckBox).addComponent(this.noCrossingLayerReassignCheckBox).addComponent(this.crossingByConnDiffCheckBox).addComponent(this.crossingResetXFromNodeCheckBox).addComponent(this.useCrossFactorCheckBox).addComponent(this.assignDuringCrossingCheckBox).addGroup(crossingPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossingPanelLayout.createSequentialGroup().addComponent(this.crossFactorFormattedTextField, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)).addGroup(crossingPanelLayout.createSequentialGroup().addComponent(this.crossingResetXMiddleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossingResetXLeftRadioButton)).addComponent(this.jLabel7)))).addGap(0, 0, Short.MAX_VALUE)));
        crossingPanelLayout.setVerticalGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossingPanelLayout.createSequentialGroup().addGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.crossingSweepCountComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noCrossingLayerReassignCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossingSortCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerCrossingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastUpCrossingSweepCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.properCrossingClosestNodeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unknownCrossingNumberChangeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyCrossingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossingByConnDiffCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossingResetXFromNodeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.crossingResetXMiddleRadioButton).addComponent(this.crossingResetXLeftRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useCrossFactorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(crossingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.crossFactorFormattedTextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assignDuringCrossingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        this.crossingScrollPane.setViewportView(this.crossingPanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.crossingScrollPane.TabConstraints.tabTitle"), this.crossingScrollPane);
        this.xAssignPanel.setPreferredSize(new Dimension(0, 0));
        this.sweepCountComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        Mnemonics.setLocalizedText((JLabel)this.sweepCountLabel, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.sweepCountLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.lastDownSweepCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.lastDownSweepCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.squashNodesCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.squashNodesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.reverseSortCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.reverseSortCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bothSortCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.bothSortCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.meanCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.meanCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.optimalUpVIPCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.optimalUpVIPCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.dummyFirstSortCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.dummyFirstSortCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.centerSimpleNodesCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.centerSimpleNodesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.delayDanglingNodesCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.delayDanglingNodesCheckBox.text"));
        GroupLayout xAssignPanelLayout = new GroupLayout(this.xAssignPanel);
        this.xAssignPanel.setLayout(xAssignPanelLayout);
        xAssignPanelLayout.setHorizontalGroup(xAssignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xAssignPanelLayout.createSequentialGroup().addGroup(xAssignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xAssignPanelLayout.createSequentialGroup().addComponent(this.sweepCountComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sweepCountLabel)).addComponent(this.optimalUpVIPCheckBox).addComponent(this.lastDownSweepCheckBox).addComponent(this.bothSortCheckBox).addComponent(this.squashNodesCheckBox).addComponent(this.reverseSortCheckBox).addComponent(this.meanCheckBox).addComponent(this.dummyFirstSortCheckBox).addComponent(this.centerSimpleNodesCheckBox).addComponent(this.delayDanglingNodesCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        xAssignPanelLayout.setVerticalGroup(xAssignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(xAssignPanelLayout.createSequentialGroup().addGroup(xAssignPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sweepCountComboBox, -2, -1, -2).addComponent(this.sweepCountLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optimalUpVIPCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastDownSweepCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.squashNodesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bothSortCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reverseSortCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.meanCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dummyFirstSortCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centerSimpleNodesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delayDanglingNodesCheckBox).addGap(0, 0, Short.MAX_VALUE)));
        this.xAssignScrollPane.setViewportView(this.xAssignPanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.xAssignScrollPane.TabConstraints.tabTitle"), this.xAssignScrollPane);
        this.yAsignPanel.setMaximumSize(new Dimension(0, 0));
        this.yAsignPanel.setPreferredSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.spanByAngleCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.spanByAngleCheckBox.text"));
        this.minEdgeAngleFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.minEdgeAngleFormattedTextField.setHorizontalAlignment(0);
        this.minEdgeAngleFormattedTextField.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.minEdgeAngleFormattedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel1.text"));
        GroupLayout yAsignPanelLayout = new GroupLayout(this.yAsignPanel);
        this.yAsignPanel.setLayout(yAsignPanelLayout);
        yAsignPanelLayout.setHorizontalGroup(yAsignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(yAsignPanelLayout.createSequentialGroup().addComponent(this.spanByAngleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minEdgeAngleFormattedTextField, -2, 48, -2).addGap(1, 1, 1).addComponent(this.jLabel1, -2, 17, -2).addGap(0, 0, Short.MAX_VALUE)));
        yAsignPanelLayout.setVerticalGroup(yAsignPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(yAsignPanelLayout.createSequentialGroup().addGroup(yAsignPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spanByAngleCheckBox).addComponent(this.minEdgeAngleFormattedTextField, -2, -1, -2).addComponent(this.jLabel1)).addGap(0, 0, Short.MAX_VALUE)));
        this.yAssignScrollPane.setViewportView(this.yAsignPanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.yAssignScrollPane.TabConstraints.tabTitle"), this.yAssignScrollPane);
        this.writePanel.setPreferredSize(new Dimension(0, 0));
        GroupLayout writePanelLayout = new GroupLayout(this.writePanel);
        this.writePanel.setLayout(writePanelLayout);
        writePanelLayout.setHorizontalGroup(writePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        writePanelLayout.setVerticalGroup(writePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.writeScrollPane.setViewportView(this.writePanel);
        this.settingsPane.addTab(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.writeScrollPane.TabConstraints.tabTitle"), this.writeScrollPane);
        Mnemonics.setLocalizedText((AbstractButton)this.previewCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.previewCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.defaultRadioB, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.defaultRadioB.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.advancedRadioB, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.advancedRadioB.text"));
        this.presetComboBox.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.presetLabel, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.presetLabel.text"));
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.generalPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.resetAdvancedButton, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.resetAdvancedButton.text"));
        this.resetAdvancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.resetAdvancedButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.advancedAsDefaultButton, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.advancedAsDefaultButton.text"));
        this.advancedAsDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.advancedToDefault(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.longEdgesCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.longEdgesCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.irrelevantCodeCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.irrelevantCodeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.noVIPCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.noVIPCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.edgeBendingCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.edgeBendingCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.stabilizedLayoutCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.stabilizedLayoutCheckBox.text"));
        this.nodeNameTextField.setText(NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.nodeNameTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.blockViewAsControlFlowCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.blockViewAsControlFlowCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.standAlonesCheckBox, (String)NbBundle.getMessage(LayoutPanel.class, (String)"LayoutPanel.standAlonesCheckBox.text"));
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.longEdgesCheckBox).addComponent(this.irrelevantCodeCheckBox).addComponent(this.noVIPCheckBox)).addGap(18, 18, 18).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.resetAdvancedButton, -1, -1, Short.MAX_VALUE).addComponent(this.advancedAsDefaultButton, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.edgeBendingCheckBox).addGroup(generalPanelLayout.createSequentialGroup().addComponent(this.nodeNameTextField, -2, 142, -2).addGap(0, 0, 0).addComponent(this.jLabel3)).addComponent(this.stabilizedLayoutCheckBox).addComponent(this.blockViewAsControlFlowCheckBox).addComponent(this.standAlonesCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.longEdgesCheckBox).addComponent(this.resetAdvancedButton, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.advancedAsDefaultButton, -2, 17, -2).addComponent(this.irrelevantCodeCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noVIPCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.edgeBendingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stabilizedLayoutCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nodeNameTextField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.blockViewAsControlFlowCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.standAlonesCheckBox)));
        this.generalScrollPane.setViewportView(this.generalPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.previewCheckBox).addGap(18, 18, 18).addComponent(this.defaultRadioB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedRadioB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.presetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.presetComboBox, -2, -1, -2)).addComponent(this.generalScrollPane, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previewCheckBox).addComponent(this.defaultRadioB).addComponent(this.advancedRadioB).addComponent(this.presetComboBox, -2, -1, -2).addComponent(this.presetLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generalScrollPane, -1, 207, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsPane, -1, 359, Short.MAX_VALUE)));
    }

    private void advancedToDefault(ActionEvent evt) {
        this.bases.forEach(action -> action.run());
        this.load();
        this.settingsChanged();
    }

    private void resetAdvancedButtonActionPerformed(ActionEvent evt) {
        this.setting.reset();
        this.load();
        this.settingsChanged();
    }
}

